<?php
/**
 * This file is automatic generated by build_docs.php file
 * and is used only for autocomplete in multiple IDE
 * don't modify manually.
 */

namespace danog\MadelineProto;

interface auth
{
    /**
     * Send the verification code for login.
     *
     * Parameters:
     * * `string`       **phone_number** - Phone number in international format
     * * `int`          **api_id**       - Application identifier (see [App configuration](https://core.telegram.org/myapp))
     * * `string`       **api_hash**     - Application secret hash (see [App configuration](https://core.telegram.org/myapp))
     * * `CodeSettings` **settings**     - Settings for the code type to send
     *
     * @param array $params Parameters
     *
     * @return auth.SentCode
     */
    public function sendCode($params);

    /**
     * Registers a validated phone number in the system.
     *
     * Parameters:
     * * `string` **phone_number**    - Phone number in the international format
     * * `string` **phone_code_hash** - SMS-message ID
     * * `string` **first_name**      - New user first name
     * * `string` **last_name**       - New user last name
     *
     * @param array $params Parameters
     *
     * @return auth.Authorization
     */
    public function signUp($params);

    /**
     * Signs in a user with a validated phone number.
     *
     * Parameters:
     * * `string` **phone_number**    - Phone number in the international format
     * * `string` **phone_code_hash** - SMS-message ID, obtained from [auth.sendCode](https://docs.madelineproto.xyz/API_docs/methods/auth.sendCode.html)
     * * `string` **phone_code**      - Valid numerical code from the SMS-message
     *
     * @param array $params Parameters
     *
     * @return auth.Authorization
     */
    public function signIn($params);

    /**
     * Logs out the user.
     *
     * @return bool
     */
    public function logOut();

    /**
     * Terminates all user's authorized sessions except for the current one.
     *
     * After calling this method it is necessary to reregister the current device using the method [account.registerDevice](https://docs.madelineproto.xyz/API_docs/methods/account.registerDevice.html)
     *
     * @return bool
     */
    public function resetAuthorizations();

    /**
     * Returns data for copying authorization to another data-centre.
     *
     * Parameters:
     * * `int` **dc_id** - Number of a target data-centre
     *
     * @param array $params Parameters
     *
     * @return auth.ExportedAuthorization
     */
    public function exportAuthorization($params);

    /**
     * Logs in a user using a key transmitted from his native data-centre.
     *
     * Parameters:
     * * `int`   **id**    - User ID
     * * `bytes` **bytes** - Authorization key
     *
     * @param array $params Parameters
     *
     * @return auth.Authorization
     */
    public function importAuthorization($params);

    /**
     * Binds a temporary authorization key `temp_auth_key_id` to the permanent authorization key `perm_auth_key_id`. Each permanent key may only be bound to one temporary key at a time, binding a new temporary key overwrites the previous one.
     *
     * For more information, see [Perfect Forward Secrecy](https://core.telegram.org/api/pfs).
     *
     * Parameters:
     * * `long`  **perm_auth_key_id**  - Permanent auth\_key\_id to bind to
     * * `long`  **nonce**             - Random long from [Binding message contents](#binding-message-contents)
     * * `int`   **expires_at**        - Unix timestamp to invalidate temporary key, see [Binding message contents](#binding-message-contents)
     * * `bytes` **encrypted_message** - See [Generating encrypted\_message](#generating-encrypted-message)
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function bindTempAuthKey($params);

    /**
     * Login as a bot.
     *
     * Parameters:
     * * `int`    **api_id**         - Application identifier (see. [App configuration](https://core.telegram.org/myapp))
     * * `string` **api_hash**       - Application identifier hash (see. [App configuration](https://core.telegram.org/myapp))
     * * `string` **bot_auth_token** - Bot token (see [bots](https://core.telegram.org/bots))
     *
     * @param array $params Parameters
     *
     * @return auth.Authorization
     */
    public function importBotAuthorization($params);

    /**
     * Try logging to an account protected by a [2FA password](https://core.telegram.org/api/srp).
     *
     * Parameters:
     * * `InputCheckPasswordSRP` **password** - The account's password (see [SRP](https://core.telegram.org/api/srp))
     *
     * @param array $params Parameters
     *
     * @return auth.Authorization
     */
    public function checkPassword($params);

    /**
     * Request recovery code of a [2FA password](https://core.telegram.org/api/srp), only for accounts with a [recovery email configured](https://core.telegram.org/api/srp#email-verification).
     *
     * @return auth.PasswordRecovery
     */
    public function requestPasswordRecovery();

    /**
     * Reset the [2FA password](https://core.telegram.org/api/srp) using the recovery code sent using [auth.requestPasswordRecovery](https://docs.madelineproto.xyz/API_docs/methods/auth.requestPasswordRecovery.html).
     *
     * Parameters:
     * * `string` **code** - Code received via email
     *
     * @param array $params Parameters
     *
     * @return auth.Authorization
     */
    public function recoverPassword($params);

    /**
     * Resend the login code via another medium, the phone code type is determined by the return value of the previous auth.sendCode/auth.resendCode: see [login](https://core.telegram.org/api/auth) for more info.
     *
     * Parameters:
     * * `string` **phone_number**    - The phone number
     * * `string` **phone_code_hash** - The phone code hash obtained from [auth.sendCode](https://docs.madelineproto.xyz/API_docs/methods/auth.sendCode.html)
     *
     * @param array $params Parameters
     *
     * @return auth.SentCode
     */
    public function resendCode($params);

    /**
     * Cancel the login verification code.
     *
     * Parameters:
     * * `string` **phone_number**    - Phone number
     * * `string` **phone_code_hash** - Phone code hash from [auth.sendCode](https://docs.madelineproto.xyz/API_docs/methods/auth.sendCode.html)
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function cancelCode($params);

    /**
     * Delete all temporary authorization keys **except for** the ones specified.
     *
     * Parameters:
     * * `[long]` **except_auth_keys** - The auth keys that **shouldn't** be dropped.
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function dropTempAuthKeys($params);

    /**
     * Generate a login token, for [login via QR code](https://core.telegram.org/api/qr-login).
     * The generated login token should be encoded using base64url, then shown as a `tg://login?token=base64encodedtoken` URL in the QR code.
     *
     * For more info, see [login via QR code](https://core.telegram.org/api/qr-login).
     *
     * Parameters:
     * * `int`    **api_id**     - Application identifier (see. [App configuration](https://core.telegram.org/myapp))
     * * `string` **api_hash**   - Application identifier hash (see. [App configuration](https://core.telegram.org/myapp))
     * * `[int]`  **except_ids** - List of already logged-in user IDs, to prevent logging in twice with the same user
     *
     * @param array $params Parameters
     *
     * @return auth.LoginToken
     */
    public function exportLoginToken($params);

    /**
     * Login using a redirected login token, generated in case of DC mismatch during [QR code login](https://core.telegram.org/api/qr-login).
     *
     * For more info, see [login via QR code](https://core.telegram.org/api/qr-login).
     *
     * Parameters:
     * * `bytes` **token** - Login token
     *
     * @param array $params Parameters
     *
     * @return auth.LoginToken
     */
    public function importLoginToken($params);

    /**
     * Accept QR code login token, logging in the app that generated it.
     *
     * Returns info about the new session.
     *
     * For more info, see [login via QR code](https://core.telegram.org/api/qr-login).
     *
     * Parameters:
     * * `bytes` **token** - Login token embedded in QR code, for more info, see [login via QR code](https://core.telegram.org/api/qr-login).
     *
     * @param array $params Parameters
     *
     * @return Authorization
     */
    public function acceptLoginToken($params);
}

interface account
{
    /**
     * Register device to receive [PUSH notifications](https://core.telegram.org/api/push-updates).
     *
     * Parameters:
     * * `boolean` **no_muted**    - Optional: Avoid receiving (silent and invisible background) notifications. Useful to save battery.
     * * `int`     **token_type**  - Device token type.<br>**Possible values**:<br>`1` \- APNS (device token for apple push)<br>`2` \- FCM (firebase token for google firebase)<br>`3` \- MPNS (channel URI for microsoft push)<br>`4` \- Simple push (endpoint for firefox's simple push API)<br>`5` \- Ubuntu phone (token for ubuntu push)<br>`6` \- Blackberry (token for blackberry push)<br>`7` \- Unused<br>`8` \- WNS (windows push)<br>`9` \- APNS VoIP (token for apple push VoIP)<br>`10` \- Web push (web push, see below)<br>`11` \- MPNS VoIP (token for microsoft push VoIP)<br>`12` \- Tizen (token for tizen push)<br><br>For `10` web push, the token must be a JSON-encoded object containing the keys described in [PUSH updates](https://core.telegram.org/api/push-updates)
     * * `string`  **token**       - Device token
     * * `Bool`    **app_sandbox** - If [(boolTrue)](https://docs.madelineproto.xyz/API_docs/constructors/boolTrue.html) is transmitted, a sandbox-certificate will be used during transmission.
     * * `bytes`   **secret**      - For FCM and APNS VoIP, optional encryption key used to encrypt push notifications
     * * `[int]`   **other_uids**  - List of user identifiers of other users currently using the client
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function registerDevice($params);

    /**
     * Deletes a device by its token, stops sending PUSH-notifications to it.
     *
     * Parameters:
     * * `int`    **token_type** - Device token type.<br>**Possible values**:<br>`1` \- APNS (device token for apple push)<br>`2` \- FCM (firebase token for google firebase)<br>`3` \- MPNS (channel URI for microsoft push)<br>`4` \- Simple push (endpoint for firefox's simple push API)<br>`5` \- Ubuntu phone (token for ubuntu push)<br>`6` \- Blackberry (token for blackberry push)<br>`7` \- Unused<br>`8` \- WNS (windows push)<br>`9` \- APNS VoIP (token for apple push VoIP)<br>`10` \- Web push (web push, see below)<br>`11` \- MPNS VoIP (token for microsoft push VoIP)<br>`12` \- Tizen (token for tizen push)<br><br>For `10` web push, the token must be a JSON-encoded object containing the keys described in [PUSH updates](https://core.telegram.org/api/push-updates)
     * * `string` **token**      - Device token
     * * `[int]`  **other_uids** - List of user identifiers of other users currently using the client
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function unregisterDevice($params);

    /**
     * Edits notification settings from a given user/group, from all users/all groups.
     *
     * Parameters:
     * * `InputNotifyPeer`         **peer**     - Notification source
     * * `InputPeerNotifySettings` **settings** - Notification settings
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function updateNotifySettings($params);

    /**
     * Gets current notification settings for a given user/group, from all users/all groups.
     *
     * Parameters:
     * * `InputNotifyPeer` **peer** - Notification source
     *
     * @param array $params Parameters
     *
     * @return PeerNotifySettings
     */
    public function getNotifySettings($params);

    /**
     * Resets all notification settings from users and groups.
     *
     * @return bool
     */
    public function resetNotifySettings();

    /**
     * Updates user profile.
     *
     * Parameters:
     * * `string` **first_name** - Optional: New user first name
     * * `string` **last_name**  - Optional: New user last name
     * * `string` **about**      - Optional: New bio
     *
     * @param array $params Parameters
     *
     * @return User
     */
    public function updateProfile($params);

    /**
     * Updates online user status.
     *
     * Parameters:
     * * `Bool` **offline** - If [(boolTrue)](https://docs.madelineproto.xyz/API_docs/constructors/boolTrue.html) is transmitted, user status will change to [(userStatusOffline)](https://docs.madelineproto.xyz/API_docs/constructors/userStatusOffline.html).
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function updateStatus($params);

    /**
     * Returns a list of available wallpapers.
     *
     * Parameters:
     * * `[int]` **hash** - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return account.WallPapers
     */
    public function getWallPapers($params);

    /**
     * Report a peer for violation of telegram's Terms of Service.
     *
     * Parameters:
     * * `InputPeer`    **peer**   - The peer to report
     * * `ReportReason` **reason** - The reason why this peer is being reported
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function reportPeer($params);

    /**
     * Validates a username and checks availability.
     *
     * Parameters:
     * * `string` **username** - username<br>Accepted characters: A-z (case-insensitive), 0-9 and underscores.<br>Length: 5-32 characters.
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function checkUsername($params);

    /**
     * Changes username for the current user.
     *
     * Parameters:
     * * `string` **username** - username or empty string if username is to be removed<br>Accepted characters: a-z (case-insensitive), 0-9 and underscores.<br>Length: 5-32 characters.
     *
     * @param array $params Parameters
     *
     * @return User
     */
    public function updateUsername($params);

    /**
     * Get privacy settings of current account.
     *
     * Parameters:
     * * `InputPrivacyKey` **key** - Peer category whose privacy settings should be fetched
     *
     * @param array $params Parameters
     *
     * @return account.PrivacyRules
     */
    public function getPrivacy($params);

    /**
     * Change privacy settings of current account.
     *
     * Parameters:
     * * `InputPrivacyKey`    **key**   - Peers to which the privacy rules apply
     * * `[InputPrivacyRule]` **rules** - New privacy rules
     *
     * @param array $params Parameters
     *
     * @return account.PrivacyRules
     */
    public function setPrivacy($params);

    /**
     * Delete the user's account from the telegram servers. Can be used, for example, to delete the account of a user that provided the login code, but forgot the [2FA password and no recovery method is configured](https://core.telegram.org/api/srp).
     *
     * Parameters:
     * * `string` **reason** - Why is the account being deleted, can be empty
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function deleteAccount($params);

    /**
     * Get days to live of account.
     *
     * @return AccountDaysTTL
     */
    public function getAccountTTL();

    /**
     * Set account self-destruction period.
     *
     * Parameters:
     * * `AccountDaysTTL` **ttl** - Time to live in days
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setAccountTTL($params);

    /**
     * Verify a new phone number to associate to the current account.
     *
     * Parameters:
     * * `string`       **phone_number** - New phone number
     * * `CodeSettings` **settings**     - Phone code settings
     *
     * @param array $params Parameters
     *
     * @return auth.SentCode
     */
    public function sendChangePhoneCode($params);

    /**
     * Change the phone number of the current account.
     *
     * Parameters:
     * * `string` **phone_number**    - New phone number
     * * `string` **phone_code_hash** - Phone code hash received when calling [account.sendChangePhoneCode](https://docs.madelineproto.xyz/API_docs/methods/account.sendChangePhoneCode.html)
     * * `string` **phone_code**      - Phone code received when calling [account.sendChangePhoneCode](https://docs.madelineproto.xyz/API_docs/methods/account.sendChangePhoneCode.html)
     *
     * @param array $params Parameters
     *
     * @return User
     */
    public function changePhone($params);

    /**
     * When client-side passcode lock feature is enabled, will not show message texts in incoming [PUSH notifications](https://core.telegram.org/api/push-updates).
     *
     * Parameters:
     * * `int` **period** - Inactivity period after which to start hiding message texts in [PUSH notifications](https://core.telegram.org/api/push-updates).
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function updateDeviceLocked($params);

    /**
     * Get logged-in sessions.
     *
     * @return account.Authorizations
     */
    public function getAuthorizations();

    /**
     * Log out an active [authorized session](https://core.telegram.org/api/auth) by its hash.
     *
     * Parameters:
     * * `long` **hash** - Session hash
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function resetAuthorization($params);

    /**
     * Obtain configuration for two-factor authorization with password.
     *
     * @return account.Password
     */
    public function getPassword();

    /**
     * Get private info associated to the password info (recovery email, telegram [passport](https://core.telegram.org/passport) info &amp; so on).
     *
     * Parameters:
     * * `InputCheckPasswordSRP` **password** - The password (see [SRP](https://core.telegram.org/api/srp))
     *
     * @param array $params Parameters
     *
     * @return account.PasswordSettings
     */
    public function getPasswordSettings($params);

    /**
     * Set a new 2FA password.
     *
     * Parameters:
     * * `InputCheckPasswordSRP`         **password**     - The old password (see [SRP](https://core.telegram.org/api/srp))
     * * `account.PasswordInputSettings` **new_settings** - The new password (see [SRP](https://core.telegram.org/api/srp))
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function updatePasswordSettings($params);

    /**
     * Send confirmation code to cancel account deletion, for more info [click here »](https://core.telegram.org/api/account-deletion).
     *
     * Parameters:
     * * `string`       **hash**     - The hash from the service notification, for more info [click here »](https://core.telegram.org/api/account-deletion)
     * * `CodeSettings` **settings** - Phone code settings
     *
     * @param array $params Parameters
     *
     * @return auth.SentCode
     */
    public function sendConfirmPhoneCode($params);

    /**
     * Confirm a phone number to cancel account deletion, for more info [click here »](https://core.telegram.org/api/account-deletion).
     *
     * Parameters:
     * * `string` **phone_code_hash** - Phone code hash, for more info [click here »](https://core.telegram.org/api/account-deletion)
     * * `string` **phone_code**      - SMS code, for more info [click here »](https://core.telegram.org/api/account-deletion)
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function confirmPhone($params);

    /**
     * Get temporary payment password.
     *
     * Parameters:
     * * `InputCheckPasswordSRP` **password** - SRP password parameters
     * * `int`                   **period**   - Time during which the temporary password will be valid, in seconds; should be between 60 and 86400
     *
     * @param array $params Parameters
     *
     * @return account.TmpPassword
     */
    public function getTmpPassword($params);

    /**
     * Get web [login widget](https://core.telegram.org/widgets/login) authorizations.
     *
     * @return account.WebAuthorizations
     */
    public function getWebAuthorizations();

    /**
     * Log out an active web [telegram login](https://core.telegram.org/widgets/login) session.
     *
     * Parameters:
     * * `long` **hash** - [Session](https://docs.madelineproto.xyz/API_docs/constructors/webAuthorization.html) hash
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function resetWebAuthorization($params);

    /**
     * Reset all active web [telegram login](https://core.telegram.org/widgets/login) sessions.
     *
     * @return bool
     */
    public function resetWebAuthorizations();

    /**
     * Get all saved [Telegram Passport](https://core.telegram.org/passport) documents, [for more info see the passport docs »](https://core.telegram.org/passport/encryption#encryption).
     *
     * @return  of SecureValue[]
     */
    public function getAllSecureValues();

    /**
     * Get saved [Telegram Passport](https://core.telegram.org/passport) document, [for more info see the passport docs »](https://core.telegram.org/passport/encryption#encryption).
     *
     * Parameters:
     * * `[SecureValueType]` **types** - Requested value types
     *
     * @param array $params Parameters
     *
     * @return  of SecureValue[]
     */
    public function getSecureValue($params);

    /**
     * Securely save [Telegram Passport](https://core.telegram.org/passport) document, [for more info see the passport docs »](https://core.telegram.org/passport/encryption#encryption).
     *
     * Parameters:
     * * `InputSecureValue` **value**            - Secure value, [for more info see the passport docs »](https://core.telegram.org/passport/encryption#encryption)
     * * `long`             **secure_secret_id** - Passport secret hash, [for more info see the passport docs »](https://core.telegram.org/passport/encryption#encryption)
     *
     * @param array $params Parameters
     *
     * @return SecureValue
     */
    public function saveSecureValue($params);

    /**
     * Delete stored [Telegram Passport](https://core.telegram.org/passport) documents, [for more info see the passport docs »](https://core.telegram.org/passport/encryption#encryption).
     *
     * Parameters:
     * * `[SecureValueType]` **types** - Document types to delete
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function deleteSecureValue($params);

    /**
     * Returns a Telegram Passport authorization form for sharing data with a service.
     *
     * Parameters:
     * * `int`    **bot_id**     - User identifier of the service's bot
     * * `string` **scope**      - Telegram Passport element types requested by the service
     * * `string` **public_key** - Service's public key
     *
     * @param array $params Parameters
     *
     * @return account.AuthorizationForm
     */
    public function getAuthorizationForm($params);

    /**
     * Sends a Telegram Passport authorization form, effectively sharing data with the service.
     *
     * Parameters:
     * * `int`                        **bot_id**       - Bot ID
     * * `string`                     **scope**        - Telegram Passport element types requested by the service
     * * `string`                     **public_key**   - Service's public key
     * * `[SecureValueHash]`          **value_hashes** - Types of values sent and their hashes
     * * `SecureCredentialsEncrypted` **credentials**  - Encrypted values
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function acceptAuthorization($params);

    /**
     * Send the verification phone code for telegram [passport](https://core.telegram.org/passport).
     *
     * Parameters:
     * * `string`       **phone_number** - The phone number to verify
     * * `CodeSettings` **settings**     - Phone code settings
     *
     * @param array $params Parameters
     *
     * @return auth.SentCode
     */
    public function sendVerifyPhoneCode($params);

    /**
     * Verify a phone number for telegram [passport](https://core.telegram.org/passport).
     *
     * Parameters:
     * * `string` **phone_number**    - Phone number
     * * `string` **phone_code_hash** - Phone code hash received from the call to [account.sendVerifyPhoneCode](https://docs.madelineproto.xyz/API_docs/methods/account.sendVerifyPhoneCode.html)
     * * `string` **phone_code**      - Code received after the call to [account.sendVerifyPhoneCode](https://docs.madelineproto.xyz/API_docs/methods/account.sendVerifyPhoneCode.html)
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function verifyPhone($params);

    /**
     * Send the verification email code for telegram [passport](https://core.telegram.org/passport).
     *
     * Parameters:
     * * `string` **email** - The email where to send the code
     *
     * @param array $params Parameters
     *
     * @return account.SentEmailCode
     */
    public function sendVerifyEmailCode($params);

    /**
     * Verify an email address for telegram [passport](https://core.telegram.org/passport).
     *
     * Parameters:
     * * `string` **email** - The email to verify
     * * `string` **code**  - The verification code that was received
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function verifyEmail($params);

    /**
     * Intialize account takeout session.
     *
     * Parameters:
     * * `boolean` **contacts**           - Optional: Whether to export contacts
     * * `boolean` **message_users**      - Optional: Whether to export messages in private chats
     * * `boolean` **message_chats**      - Optional: Whether to export messages in [legacy groups](https://core.telegram.org/api/channel)
     * * `boolean` **message_megagroups** - Optional: Whether to export messages in [supergroups](https://core.telegram.org/api/channel)
     * * `boolean` **message_channels**   - Optional: Whether to export messages in [channels](https://core.telegram.org/api/channel)
     * * `boolean` **files**              - Optional: Whether to export files
     * * `int`     **file_max_size**      - Optional: Maximum size of files to export
     *
     * @param array $params Parameters
     *
     * @return account.Takeout
     */
    public function initTakeoutSession($params);

    /**
     * Finish account takeout session.
     *
     * Parameters:
     * * `boolean` **success** - Optional: Data exported successfully
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function finishTakeoutSession($params);

    /**
     * Verify an email to use as [2FA recovery method](https://core.telegram.org/api/srp).
     *
     * Parameters:
     * * `string` **code** - The phone code that was received after [setting a recovery email](https://core.telegram.org/api/srp#email-verification)
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function confirmPasswordEmail($params);

    /**
     * Resend the code to verify an email to use as [2FA recovery method](https://core.telegram.org/api/srp).
     *
     * @return bool
     */
    public function resendPasswordEmail();

    /**
     * Cancel the code that was sent to verify an email to use as [2FA recovery method](https://core.telegram.org/api/srp).
     *
     * @return bool
     */
    public function cancelPasswordEmail();

    /**
     * Whether the user will receive notifications when contacts sign up.
     *
     * @return bool
     */
    public function getContactSignUpNotification();

    /**
     * Toggle contact sign up notifications.
     *
     * Parameters:
     * * `Bool` **silent** - Whether to disable contact sign up notifications
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setContactSignUpNotification($params);

    /**
     * Returns list of chats with non-default notification settings.
     *
     * Parameters:
     * * `boolean`         **compare_sound** - Optional: If true, chats with non-default sound will also be returned
     * * `InputNotifyPeer` **peer**          - Optional: If specified, only chats of the specified category will be returned
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function getNotifyExceptions($params);

    /**
     * Get info about a certain wallpaper.
     *
     * Parameters:
     * * `InputWallPaper` **wallpaper** - The wallpaper to get info about
     *
     * @param array $params Parameters
     *
     * @return WallPaper
     */
    public function getWallPaper($params);

    /**
     * Create and upload a new wallpaper.
     *
     * Parameters:
     * * `InputFile`         **file**      - The JPG/PNG wallpaper
     * * `string`            **mime_type** - MIME type of uploaded wallpaper
     * * `WallPaperSettings` **settings**  - Wallpaper settings
     *
     * @param array $params Parameters
     *
     * @return WallPaper
     */
    public function uploadWallPaper($params);

    /**
     * Install/uninstall wallpaper.
     *
     * Parameters:
     * * `InputWallPaper`    **wallpaper** - Wallpaper to save
     * * `Bool`              **unsave**    - Uninstall wallpaper?
     * * `WallPaperSettings` **settings**  - Wallpaper settings
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function saveWallPaper($params);

    /**
     * Install wallpaper.
     *
     * Parameters:
     * * `InputWallPaper`    **wallpaper** - Wallpaper to install
     * * `WallPaperSettings` **settings**  - Wallpaper settings
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function installWallPaper($params);

    /**
     * Delete installed wallpapers.
     *
     * @return bool
     */
    public function resetWallPapers();

    /**
     * Get media autodownload settings.
     *
     * @return account.AutoDownloadSettings
     */
    public function getAutoDownloadSettings();

    /**
     * Change media autodownload settings.
     *
     * Parameters:
     * * `boolean`              **low**      - Optional: Whether to save settings in the low data usage preset
     * * `boolean`              **high**     - Optional: Whether to save settings in the high data usage preset
     * * `AutoDownloadSettings` **settings** - Media autodownload settings
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function saveAutoDownloadSettings($params);

    /**
     * Upload theme.
     *
     * Parameters:
     * * `InputFile` **file**      - Theme file uploaded as described in [files »](https://core.telegram.org/api/files)
     * * `InputFile` **thumb**     - Optional: Thumbnail
     * * `string`    **file_name** - File name
     * * `string`    **mime_type** - MIME type, must be `application/x-tgtheme-{format}`, where `format` depends on the client
     *
     * @param array $params Parameters
     *
     * @return Document
     */
    public function uploadTheme($params);

    /**
     * Create a theme.
     *
     * Parameters:
     * * `string`             **slug**     - Unique theme ID
     * * `string`             **title**    - Theme name
     * * `InputDocument`      **document** - Optional: Theme file
     * * `InputThemeSettings` **settings** - Optional: Theme settings
     *
     * @param array $params Parameters
     *
     * @return Theme
     */
    public function createTheme($params);

    /**
     * Update theme.
     *
     * Parameters:
     * * `string`             **format**   - Theme format, a string that identifies the theming engines supported by the client
     * * `InputTheme`         **theme**    - Theme to update
     * * `string`             **slug**     - Optional: Unique theme ID
     * * `string`             **title**    - Optional: Theme name
     * * `InputDocument`      **document** - Optional: Theme file
     * * `InputThemeSettings` **settings** - Optional: Theme settings
     *
     * @param array $params Parameters
     *
     * @return Theme
     */
    public function updateTheme($params);

    /**
     * Save a theme.
     *
     * Parameters:
     * * `InputTheme` **theme**  - Theme to save
     * * `Bool`       **unsave** - Unsave
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function saveTheme($params);

    /**
     * Install a theme.
     *
     * Parameters:
     * * `boolean`    **dark**   - Optional: Whether to install the dark version
     * * `string`     **format** - Optional: Theme format, a string that identifies the theming engines supported by the client
     * * `InputTheme` **theme**  - Optional: Theme to install
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function installTheme($params);

    /**
     * Get theme information.
     *
     * Parameters:
     * * `string`     **format**      - Theme format, a string that identifies the theming engines supported by the client
     * * `InputTheme` **theme**       - Theme
     * * `long`       **document_id** - Document ID
     *
     * @param array $params Parameters
     *
     * @return Theme
     */
    public function getTheme($params);

    /**
     * Get installed themes.
     *
     * Parameters:
     * * `string` **format** - Theme format, a string that identifies the theming engines supported by the client
     * * `[int]`  **hash**   - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return account.Themes
     */
    public function getThemes($params);

    /**
     * Set sensitive content settings (for viewing or hiding NSFW content).
     *
     * Parameters:
     * * `boolean` **sensitive_enabled** - Optional: Enable NSFW content
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setContentSettings($params);

    /**
     * Get sensitive content settings.
     *
     * @return account.ContentSettings
     */
    public function getContentSettings();

    /**
     * Get info about multiple wallpapers.
     *
     * Parameters:
     * * `[InputWallPaper]` **wallpapers** - Wallpapers to fetch info about
     *
     * @param array $params Parameters
     *
     * @return  of WallPaper[]
     */
    public function getMultiWallPapers($params);

    /**
     *
     *
     * @return GlobalPrivacySettings
     */
    public function getGlobalPrivacySettings();

    /**
     *
     *
     * Parameters:
     * * `GlobalPrivacySettings` **settings** -.
     *
     * @param array $params Parameters
     *
     * @return GlobalPrivacySettings
     */
    public function setGlobalPrivacySettings($params);
}

interface users
{
    /**
     * Returns basic user info according to their identifiers.
     *
     * Parameters:
     * * `[InputUser]` **id** - List of user identifiers
     *
     * @param array $params Parameters
     *
     * @return  of User[]
     */
    public function getUsers($params);

    /**
     * Returns extended user info by ID.
     *
     * Parameters:
     * * `InputUser` **id** - User ID
     *
     * @param array $params Parameters
     *
     * @return UserFull
     */
    public function getFullUser($params);

    /**
     * Notify the user that the sent [passport](https://core.telegram.org/passport) data contains some errors The user will not be able to re-submit their Passport data to you until the errors are fixed (the contents of the field for which you returned the error must change).
     *
     * Use this if the data submitted by the user doesn't satisfy the standards your service requires for any reason. For example, if a birthday date seems invalid, a submitted document is blurry, a scan shows evidence of tampering, etc. Supply some details in the error message to make sure the user knows how to correct the issues.
     *
     * Parameters:
     * * `InputUser`          **id**     - The user
     * * `[SecureValueError]` **errors** - Errors
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setSecureValueErrors($params);
}

interface contacts
{
    /**
     * Get contact by telegram IDs.
     *
     * Parameters:
     * * `[int]` **hash** - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return  of int[]
     */
    public function getContactIDs($params);

    /**
     * Returns the list of contact statuses.
     *
     * @return  of ContactStatus[]
     */
    public function getStatuses();

    /**
     * Returns the current user's contact list.
     *
     * Parameters:
     * * `[int]` **hash** - Optional: If there already is a full contact list on the client, a [hash](https://core.telegram.org/api/offsets#hash-generation) of a the list of contact IDs in ascending order may be passed in this parameter. If the contact set was not changed, [(contacts.contactsNotModified)](https://docs.madelineproto.xyz/API_docs/constructors/contacts.contactsNotModified.html) will be returned.
     *
     * @param array $params Parameters
     *
     * @return contacts.Contacts
     */
    public function getContacts($params);

    /**
     * Imports contacts: saves a full list on the server, adds already registered contacts to the contact list, returns added contacts and their info.
     *
     * Use [contacts.addContact](https://docs.madelineproto.xyz/API_docs/methods/contacts.addContact.html) to add Telegram contacts without actually using their phone number.
     *
     * Parameters:
     * * `[InputContact]` **contacts** - List of contacts to import
     *
     * @param array $params Parameters
     *
     * @return contacts.ImportedContacts
     */
    public function importContacts($params);

    /**
     * Deletes several contacts from the list.
     *
     * Parameters:
     * * `[InputUser]` **id** - User ID list
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function deleteContacts($params);

    /**
     * Delete contacts by phone number.
     *
     * Parameters:
     * * `[string]` **phones** - Phone numbers
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function deleteByPhones($params);

    /**
     * Adds the user to the blacklist.
     *
     * Parameters:
     * * `InputPeer` **id** -
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function block($params);

    /**
     * Deletes the user from the blacklist.
     *
     * Parameters:
     * * `InputPeer` **id** -
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function unblock($params);

    /**
     * Returns the list of blocked users.
     *
     * Parameters:
     * * `int` **offset** - The number of list elements to be skipped
     * * `int` **limit**  - The number of list elements to be returned
     *
     * @param array $params Parameters
     *
     * @return contacts.Blocked
     */
    public function getBlocked($params);

    /**
     * Returns users found by username substring.
     *
     * Parameters:
     * * `string` **q**     - Target substring
     * * `int`    **limit** - Maximum number of users to be returned
     *
     * @param array $params Parameters
     *
     * @return contacts.Found
     */
    public function search($params);

    /**
     * Resolve a @username to get peer info.
     *
     * Parameters:
     * * `string` **username** - @username to resolve
     *
     * @param array $params Parameters
     *
     * @return contacts.ResolvedPeer
     */
    public function resolveUsername($params);

    /**
     * Get most used peers.
     *
     * Parameters:
     * * `boolean` **correspondents** - Optional: Users we've chatted most frequently with
     * * `boolean` **bots_pm**        - Optional: Most used bots
     * * `boolean` **bots_inline**    - Optional: Most used inline bots
     * * `boolean` **phone_calls**    - Optional: Most frequently called users
     * * `boolean` **forward_users**  - Optional: Users to which the users often forwards messages to
     * * `boolean` **forward_chats**  - Optional: Chats to which the users often forwards messages to
     * * `boolean` **groups**         - Optional: Often-opened groups and supergroups
     * * `boolean` **channels**       - Optional: Most frequently visited channels
     * * `int`     **offset**         - Offset for [pagination](https://core.telegram.org/api/offsets)
     * * `int`     **limit**          - Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * * `[int]`   **hash**           - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return contacts.TopPeers
     */
    public function getTopPeers($params);

    /**
     * Reset [rating](https://core.telegram.org/api/top-rating) of top peer.
     *
     * Parameters:
     * * `TopPeerCategory` **category** - Top peer category
     * * `InputPeer`       **peer**     - Peer whose rating should be reset
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function resetTopPeerRating($params);

    /**
     * Delete saved contacts.
     *
     * @return bool
     */
    public function resetSaved();

    /**
     * Get all contacts.
     *
     * @return  of SavedContact[]
     */
    public function getSaved();

    /**
     * Enable/disable [top peers](https://core.telegram.org/api/top-rating).
     *
     * Parameters:
     * * `Bool` **enabled** - Enable/disable
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function toggleTopPeers($params);

    /**
     * Add an existing telegram user as contact.
     *
     * Use [contacts.importContacts](https://docs.madelineproto.xyz/API_docs/methods/contacts.importContacts.html) to add contacts by phone number, without knowing their Telegram ID.
     *
     * Parameters:
     * * `boolean`   **add_phone_privacy_exception** - Optional: Allow the other user to see our phone number?
     * * `InputUser` **id**                          - Telegram ID of the other user
     * * `string`    **first_name**                  - First name
     * * `string`    **last_name**                   - Last name
     * * `string`    **phone**                       - User's phone number
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function addContact($params);

    /**
     * If the [peer settings](https://docs.madelineproto.xyz/API_docs/constructors/peerSettings.html) of a new user allow us to add him as contact, add that user as contact.
     *
     * Parameters:
     * * `InputUser` **id** - The user to add as contact
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function acceptContact($params);

    /**
     * Get contacts near you.
     *
     * Parameters:
     * * `boolean`       **background**   - Optional: While the geolocation of the current user is public, clients should update it in the background every half-an-hour or so, while setting this flag. <br>Do this only if the new location is more than 1 KM away from the previous one, or if the previous location is unknown.
     * * `InputGeoPoint` **geo_point**    - Geolocation
     * * `int`           **self_expires** - Optional: If set, the geolocation of the current user will be public for the specified number of seconds; pass 0x7fffffff to disable expiry, 0 to make the current geolocation private; if the flag isn't set, no changes will be applied.
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function getLocated($params);

    /**
     *
     *
     * Parameters:
     * * `boolean` **delete_message** - Optional:
     * * `boolean` **delete_history** - Optional:
     * * `boolean` **report_spam**    - Optional:
     * * `int`     **msg_id**         -.
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function blockFromReplies($params);
}

interface messages
{
    /**
     * Returns the list of messages by their IDs.
     *
     * Parameters:
     * * `[InputMessage]` **id** - Message ID list
     *
     * @param array $params Parameters
     *
     * @return messages.Messages
     */
    public function getMessages($params);

    /**
     * Returns the current user dialog list.
     *
     * Parameters:
     * * `boolean`   **exclude_pinned** - Optional: Exclude pinned dialogs
     * * `int`       **folder_id**      - Optional: [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
     * * `int`       **offset_date**    - [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * * `int`       **offset_id**      - [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * * `InputPeer` **offset_peer**    - [Offset peer for pagination](https://core.telegram.org/api/offsets)
     * * `int`       **limit**          - Number of list elements to be returned
     * * `[int]`     **hash**           - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return messages.Dialogs
     */
    public function getDialogs($params);

    /**
     * Gets back the conversation history with one interlocutor / within a chat.
     *
     * Parameters:
     * * `InputPeer` **peer**        - Target peer
     * * `int`       **offset_id**   - Only return messages starting from the specified message ID
     * * `int`       **offset_date** - Only return messages sent before the specified date
     * * `int`       **add_offset**  - Number of list elements to be skipped, negative values are also accepted.
     * * `int`       **limit**       - Number of results to return
     * * `int`       **max_id**      - If a positive value was transferred, the method will return only messages with IDs less than **max\_id**
     * * `int`       **min_id**      - If a positive value was transferred, the method will return only messages with IDs more than **min\_id**
     * * `[int]`     **hash**        - Optional: [Result hash](https://core.telegram.org/api/offsets)
     *
     * @param array $params Parameters
     *
     * @return messages.Messages
     */
    public function getHistory($params);

    /**
     * Gets back found messages.
     *
     * Parameters:
     * * `InputPeer`      **peer**       - User or chat, histories with which are searched, or [(inputPeerEmpty)](https://docs.madelineproto.xyz/API_docs/constructors/inputPeerEmpty.html) constructor for global search
     * * `string`         **q**          - Text search request
     * * `InputPeer`      **from_id**    - Optional:
     * * `int`            **top_msg_id** - Optional:
     * * `MessagesFilter` **filter**     - Filter to return only specified message types
     * * `int`            **min_date**   - If a positive value was transferred, only messages with a sending date bigger than the transferred one will be returned
     * * `int`            **max_date**   - If a positive value was transferred, only messages with a sending date smaller than the transferred one will be returned
     * * `int`            **offset_id**  - Only return messages starting from the specified message ID
     * * `int`            **add_offset** - [Additional offset](https://core.telegram.org/api/offsets)
     * * `int`            **limit**      - [Number of results to return](https://core.telegram.org/api/offsets)
     * * `int`            **max_id**     - [Maximum message ID to return](https://core.telegram.org/api/offsets)
     * * `int`            **min_id**     - [Minimum message ID to return](https://core.telegram.org/api/offsets)
     * * `[int]`          **hash**       - Optional: [Hash](https://core.telegram.org/api/offsets)
     *
     * @param array $params Parameters
     *
     * @return messages.Messages
     */
    public function search($params);

    /**
     * Marks message history as read.
     *
     * Parameters:
     * * `InputPeer` **peer**   - Target user or group
     * * `int`       **max_id** - If a positive value is passed, only messages with identifiers less or equal than the given one will be read
     *
     * @param array $params Parameters
     *
     * @return messages.AffectedMessages
     */
    public function readHistory($params);

    /**
     * Deletes communication history.
     *
     * Parameters:
     * * `boolean`   **just_clear** - Optional: Just clear history for the current user, without actually removing messages for every chat user
     * * `boolean`   **revoke**     - Optional: Whether to delete the message history for all chat participants
     * * `InputPeer` **peer**       - User or chat, communication history of which will be deleted
     * * `int`       **max_id**     - Maximum ID of message to delete
     *
     * @param array $params Parameters
     *
     * @return messages.AffectedHistory
     */
    public function deleteHistory($params);

    /**
     * Deletes messages by their identifiers.
     *
     * Parameters:
     * * `boolean` **revoke** - Optional: Whether to delete messages for all participants of the chat
     * * `[int]`   **id**     - Message ID list
     *
     * @param array $params Parameters
     *
     * @return messages.AffectedMessages
     */
    public function deleteMessages($params);

    /**
     * Confirms receipt of messages by a client, cancels PUSH-notification sending.
     *
     * Parameters:
     * * `int` **max_id** - Maximum message ID available in a client.
     *
     * @param array $params Parameters
     *
     * @return  of ReceivedNotifyMessage[]
     */
    public function receivedMessages($params);

    /**
     * Sends a current user typing event (see [SendMessageAction](https://docs.madelineproto.xyz/API_docs/types/SendMessageAction.html) for all event types) to a conversation partner or group.
     *
     * Parameters:
     * * `InputPeer`         **peer**       - Target user or group
     * * `int`               **top_msg_id** - Optional:
     * * `SendMessageAction` **action**     - Type of action<br>Parameter added in [Layer 17](https://core.telegram.org/api/layers#layer-17).
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setTyping($params);

    /**
     * Sends a message to a chat.
     *
     * Parameters:
     * * `boolean`         **no_webpage**      - Optional: Set this flag to disable generation of the webpage preview
     * * `boolean`         **silent**          - Optional: Send this message silently (no notifications for the receivers)
     * * `boolean`         **background**      - Optional: Send this message as background message
     * * `boolean`         **clear_draft**     - Optional: Clear the draft field
     * * `InputPeer`       **peer**            - The destination where the message will be sent
     * * `int`             **reply_to_msg_id** - Optional: The message ID to which this message will reply to
     * * `string`          **message**         - The message
     * * `ReplyMarkup`     **reply_markup**    - Optional: Reply markup for sending bot buttons
     * * `[MessageEntity]` **entities**        - Optional: Message [entities](https://core.telegram.org/api/entities) for sending styled text
     * * `int`             **schedule_date**   - Optional: Scheduled message date for scheduled messages
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function sendMessage($params);

    /**
     * Send a media.
     *
     * Parameters:
     * * `boolean`         **silent**          - Optional: Send message silently (no notification should be triggered)
     * * `boolean`         **background**      - Optional: Send message in background
     * * `boolean`         **clear_draft**     - Optional: Clear the draft
     * * `InputPeer`       **peer**            - Destination
     * * `int`             **reply_to_msg_id** - Optional: Message ID to which this message should reply to
     * * `InputMedia`      **media**           - Attached media
     * * `string`          **message**         - Caption
     * * `ReplyMarkup`     **reply_markup**    - Optional: Reply markup for bot keyboards
     * * `[MessageEntity]` **entities**        - Optional: Message [entities](https://core.telegram.org/api/entities) for styled text
     * * `int`             **schedule_date**   - Optional: Scheduled message date for scheduled messages
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function sendMedia($params);

    /**
     * Forwards messages by their IDs.
     *
     * Parameters:
     * * `boolean`   **silent**        - Optional: Whether to send messages silently (no notification will be triggered on the destination clients)
     * * `boolean`   **background**    - Optional: Whether to send the message in background
     * * `boolean`   **with_my_score** - Optional: When forwarding games, whether to include your score in the game
     * * `InputPeer` **from_peer**     - Source of messages
     * * `[int]`     **id**            - IDs of messages
     * * `InputPeer` **to_peer**       - Destination peer
     * * `int`       **schedule_date** - Optional: Scheduled message date for scheduled messages
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function forwardMessages($params);

    /**
     * Report a new incoming chat for spam, if the [peer settings](https://docs.madelineproto.xyz/API_docs/constructors/peerSettings.html) of the chat allow us to do that.
     *
     * Parameters:
     * * `InputPeer` **peer** - Peer to report
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function reportSpam($params);

    /**
     * Get peer settings.
     *
     * Parameters:
     * * `InputPeer` **peer** - The peer
     *
     * @param array $params Parameters
     *
     * @return PeerSettings
     */
    public function getPeerSettings($params);

    /**
     * Report a message in a chat for violation of telegram's Terms of Service.
     *
     * Parameters:
     * * `InputPeer`    **peer**   - Peer
     * * `[int]`        **id**     - IDs of messages to report
     * * `ReportReason` **reason** - Why are these messages being reported
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function report($params);

    /**
     * Returns chat basic info on their IDs.
     *
     * Parameters:
     * * `[int]` **id** - List of chat IDs
     *
     * @param array $params Parameters
     *
     * @return messages.Chats
     */
    public function getChats($params);

    /**
     * Returns full chat info according to its ID.
     *
     * Parameters:
     * * `InputPeer` **chat_id** -
     *
     * @param array $params Parameters
     *
     * @return messages.ChatFull
     */
    public function getFullChat($params);

    /**
     * Chanages chat name and sends a service message on it.
     *
     * Parameters:
     * * `InputPeer` **chat_id** -
     * * `string`    **title**   - New chat name, different from the old one
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function editChatTitle($params);

    /**
     * Changes chat photo and sends a service message on it.
     *
     * Parameters:
     * * `InputPeer`      **chat_id** -
     * * `InputChatPhoto` **photo**   - Photo to be set
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function editChatPhoto($params);

    /**
     * Adds a user to a chat and sends a service message on it.
     *
     * Parameters:
     * * `InputPeer` **chat_id**   -
     * * `InputUser` **user_id**   - User ID to be added
     * * `int`       **fwd_limit** - Number of last messages to be forwarded
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function addChatUser($params);

    /**
     * Deletes a user from a chat and sends a service message on it.
     *
     * Parameters:
     * * `InputPeer` **chat_id** -
     * * `InputUser` **user_id** - User ID to be deleted
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function deleteChatUser($params);

    /**
     * Creates a new chat.
     *
     * Parameters:
     * * `[InputUser]` **users** - List of user IDs to be invited
     * * `string`      **title** - Chat name
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function createChat($params);

    /**
     * Returns configuration parameters for Diffie-Hellman key generation. Can also return a random sequence of bytes of required length.
     *
     * Parameters:
     * * `int` **version**       - Value of the **version** parameter from [messages.dhConfig](https://docs.madelineproto.xyz/API_docs/constructors/messages.dhConfig.html), avialable at the client
     * * `int` **random_length** - Length of the required random sequence
     *
     * @param array $params Parameters
     *
     * @return messages.DhConfig
     */
    public function getDhConfig($params);

    /**
     * Sends a request to start a secret chat to the user.
     *
     * Parameters:
     * * `InputUser` **user_id** - User ID
     * * `bytes`     **g_a**     - `A = g ^ a mod p`, see [Wikipedia](https://en.wikipedia.org/wiki/Diffie%E2%80%93Hellman_key_exchange)
     *
     * @param array $params Parameters
     *
     * @return EncryptedChat
     */
    public function requestEncryption($params);

    /**
     * Confirms creation of a secret chat.
     *
     * Parameters:
     * * `InputEncryptedChat` **peer**            - Secret chat ID
     * * `bytes`              **g_b**             - `B = g ^ b mod p`, see [Wikipedia](https://en.wikipedia.org/wiki/Diffie%E2%80%93Hellman_key_exchange)
     * * `long`               **key_fingerprint** - 64-bit fingerprint of the received key
     *
     * @param array $params Parameters
     *
     * @return EncryptedChat
     */
    public function acceptEncryption($params);

    /**
     * Cancels a request for creation and/or delete info on secret chat.
     *
     * Parameters:
     * * `int` **chat_id** - Secret chat ID
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function discardEncryption($params);

    /**
     * Send typing event by the current user to a secret chat.
     *
     * Parameters:
     * * `InputEncryptedChat` **peer**   - Secret chat ID
     * * `Bool`               **typing** - Typing.<br>**Possible values**:<br>[(boolTrue)](https://docs.madelineproto.xyz/API_docs/constructors/boolTrue.html), if the user started typing and more than **5 seconds** have passed since the last request<br>[(boolFalse)](https://docs.madelineproto.xyz/API_docs/constructors/boolFalse.html), if the user stopped typing
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setEncryptedTyping($params);

    /**
     * Marks message history within a secret chat as read.
     *
     * Parameters:
     * * `InputEncryptedChat` **peer**     - Secret chat ID
     * * `int`                **max_date** - Maximum date value for received messages in history
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function readEncryptedHistory($params);

    /**
     * Sends a text message to a secret chat.
     *
     * Parameters:
     * * `boolean`            **silent**  - Optional:
     * * `InputEncryptedChat` **peer**    - Secret chat ID
     * * `DecryptedMessage`   **message** -
     *
     * @param array $params Parameters
     *
     * @return messages.SentEncryptedMessage
     */
    public function sendEncrypted($params);

    /**
     * Sends a message with a file attachment to a secret chat.
     *
     * Parameters:
     * * `boolean`            **silent**  - Optional:
     * * `InputEncryptedChat` **peer**    - Secret chat ID
     * * `DecryptedMessage`   **message** -
     * * `InputEncryptedFile` **file**    - File attachment for the secret chat
     *
     * @param array $params Parameters
     *
     * @return messages.SentEncryptedMessage
     */
    public function sendEncryptedFile($params);

    /**
     * Sends a service message to a secret chat.
     *
     * Parameters:
     * * `InputEncryptedChat` **peer**    - Secret chat ID
     * * `DecryptedMessage`   **message** -
     *
     * @param array $params Parameters
     *
     * @return messages.SentEncryptedMessage
     */
    public function sendEncryptedService($params);

    /**
     * Confirms receipt of messages in a secret chat by client, cancels push notifications.
     *
     * Parameters:
     * * `int` **max_qts** - Maximum qts value available at the client
     *
     * @param array $params Parameters
     *
     * @return  of long[]
     */
    public function receivedQueue($params);

    /**
     * Report a secret chat for spam.
     *
     * Parameters:
     * * `InputEncryptedChat` **peer** - The secret chat to report
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function reportEncryptedSpam($params);

    /**
     * Notifies the sender about the recipient having listened a voice message or watched a video.
     *
     * Parameters:
     * * `[int]` **id** - Message ID list
     *
     * @param array $params Parameters
     *
     * @return messages.AffectedMessages
     */
    public function readMessageContents($params);

    /**
     * Get stickers by emoji.
     *
     * Parameters:
     * * `string` **emoticon** - The emoji
     * * `[int]`  **hash**     - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return messages.Stickers
     */
    public function getStickers($params);

    /**
     * Get all installed stickers.
     *
     * Parameters:
     * * `[int]` **hash** - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return messages.AllStickers
     */
    public function getAllStickers($params);

    /**
     * Get preview of webpage.
     *
     * Parameters:
     * * `string`          **message**  - Message from which to extract the preview
     * * `[MessageEntity]` **entities** - Optional: [Message entities for styled text](https://core.telegram.org/api/entities)
     *
     * @param array $params Parameters
     *
     * @return MessageMedia
     */
    public function getWebPagePreview($params);

    /**
     * Export an invite link for a chat.
     *
     * Parameters:
     * * `InputPeer` **peer** - Chat
     *
     * @param array $params Parameters
     *
     * @return ExportedChatInvite
     */
    public function exportChatInvite($params);

    /**
     * Check the validity of a chat invite link and get basic info about it.
     *
     * Parameters:
     * * `string` **hash** - Invite hash in `t.me/joinchat/hash`
     *
     * @param array $params Parameters
     *
     * @return ChatInvite
     */
    public function checkChatInvite($params);

    /**
     * Import a chat invite and join a private chat/supergroup/channel.
     *
     * Parameters:
     * * `string` **hash** - `hash` from `t.me/joinchat/hash`
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function importChatInvite($params);

    /**
     * Get info about a stickerset.
     *
     * Parameters:
     * * `InputStickerSet` **stickerset** - Stickerset
     *
     * @param array $params Parameters
     *
     * @return messages.StickerSet
     */
    public function getStickerSet($params);

    /**
     * Install a stickerset.
     *
     * Parameters:
     * * `InputStickerSet` **stickerset** - Stickerset to install
     * * `Bool`            **archived**   - Whether to archive stickerset
     *
     * @param array $params Parameters
     *
     * @return messages.StickerSetInstallResult
     */
    public function installStickerSet($params);

    /**
     * Uninstall a stickerset.
     *
     * Parameters:
     * * `InputStickerSet` **stickerset** - The stickerset to uninstall
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function uninstallStickerSet($params);

    /**
     * Start a conversation with a bot using a [deep linking parameter](https://core.telegram.org/bots#deep-linking).
     *
     * Parameters:
     * * `InputUser` **bot**         - The bot
     * * `InputPeer` **peer**        - The chat where to start the bot, can be the bot's private chat or a group
     * * `string`    **start_param** - [Deep linking parameter](https://core.telegram.org/bots#deep-linking)
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function startBot($params);

    /**
     * Get and increase the view counter of a message sent or forwarded from a [channel](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputPeer` **peer**      - Peer where the message was found
     * * `[int]`     **id**        - ID of message
     * * `Bool`      **increment** - Whether to mark the message as viewed and increment the view counter
     *
     * @param array $params Parameters
     *
     * @return messages.MessageViews
     */
    public function getMessagesViews($params);

    /**
     * Make a user admin in a [legacy group](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputPeer` **chat_id**  -
     * * `InputUser` **user_id**  - The user to make admin
     * * `Bool`      **is_admin** - Whether to make him admin
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function editChatAdmin($params);

    /**
     * Turn a [legacy group into a supergroup](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputPeer` **chat_id** -
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function migrateChat($params);

    /**
     * Search for messages and peers globally.
     *
     * Parameters:
     * * `int`            **folder_id**   - Optional: [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
     * * `string`         **q**           - Query
     * * `MessagesFilter` **filter**      -
     * * `int`            **min_date**    -
     * * `int`            **max_date**    -
     * * `int`            **offset_rate** - Initially 0, then set to the [`next_rate` parameter of messages.messagesSlice](https://docs.madelineproto.xyz/API_docs/constructors/messages.messagesSlice.html)
     * * `InputPeer`      **offset_peer** - [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * * `int`            **offset_id**   - [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * * `int`            **limit**       - [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     *
     * @param array $params Parameters
     *
     * @return messages.Messages
     */
    public function searchGlobal($params);

    /**
     * Reorder installed stickersets.
     *
     * Parameters:
     * * `boolean` **masks** - Optional: Reorder mask stickersets
     * * `[long]`  **order** - New stickerset order by stickerset IDs
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function reorderStickerSets($params);

    /**
     * Get a document by its SHA256 hash, mainly used for gifs.
     *
     * Parameters:
     * * `bytes`  **sha256**    - SHA256 of file
     * * `int`    **size**      - Size of the file in bytes
     * * `string` **mime_type** - Mime type
     *
     * @param array $params Parameters
     *
     * @return Document
     */
    public function getDocumentByHash($params);

    /**
     * Get saved GIFs.
     *
     * Parameters:
     * * `[int]` **hash** - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return messages.SavedGifs
     */
    public function getSavedGifs($params);

    /**
     * Add GIF to saved gifs list.
     *
     * Parameters:
     * * `InputDocument` **id**     - GIF to save
     * * `Bool`          **unsave** - Whether to remove GIF from saved gifs list
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function saveGif($params);

    /**
     * Query an inline bot.
     *
     * Parameters:
     * * `InputUser`     **bot**       - The bot to query
     * * `InputPeer`     **peer**      - The currently opened chat
     * * `InputGeoPoint` **geo_point** - Optional: The geolocation, if requested
     * * `string`        **query**     - The query
     * * `string`        **offset**    - The offset within the results, will be passed directly as-is to the bot.
     *
     * @param array $params Parameters
     *
     * @return messages.BotResults
     */
    public function getInlineBotResults($params);

    /**
     * Answer an inline query, for bots only.
     *
     * Parameters:
     * * `boolean`                **gallery**     - Optional: Set this flag if the results are composed of media files
     * * `boolean`                **private**     - Optional: Set this flag if results may be cached on the server side only for the user that sent the query. By default, results may be returned to any user who sends the same query
     * * `long`                   **query_id**    - Unique identifier for the answered query
     * * `[InputBotInlineResult]` **results**     - Vector of results for the inline query
     * * `int`                    **cache_time**  - The maximum amount of time in seconds that the result of the inline query may be cached on the server. Defaults to 300.
     * * `string`                 **next_offset** - Optional: Pass the offset that a client should send in the next query with the same text to receive more results. Pass an empty string if there are no more results or if you don‘t support pagination. Offset length can’t exceed 64 bytes.
     * * `InlineBotSwitchPM`      **switch_pm**   - Optional: If passed, clients will display a button with specified text that switches the user to a private chat with the bot and sends the bot a start message with a certain parameter.
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setInlineBotResults($params);

    /**
     * Send a result obtained using [messages.getInlineBotResults](https://docs.madelineproto.xyz/API_docs/methods/messages.getInlineBotResults.html).
     *
     * Parameters:
     * * `boolean`   **silent**          - Optional: Whether to send the message silently (no notification will be triggered on the other client)
     * * `boolean`   **background**      - Optional: Whether to send the message in background
     * * `boolean`   **clear_draft**     - Optional: Whether to clear the [draft](https://core.telegram.org/api/drafts)
     * * `boolean`   **hide_via**        - Optional: Whether to hide the `via @botname` in the resulting message (only for bot usernames encountered in the [config](https://docs.madelineproto.xyz/API_docs/constructors/config.html))
     * * `InputPeer` **peer**            - Destination
     * * `int`       **reply_to_msg_id** - Optional: ID of the message this message should reply to
     * * `long`      **query_id**        - Query ID from [messages.getInlineBotResults](https://docs.madelineproto.xyz/API_docs/methods/messages.getInlineBotResults.html)
     * * `string`    **id**              - Result ID from [messages.getInlineBotResults](https://docs.madelineproto.xyz/API_docs/methods/messages.getInlineBotResults.html)
     * * `int`       **schedule_date**   - Optional: Scheduled message date for scheduled messages
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function sendInlineBotResult($params);

    /**
     * Find out if a media message's caption can be edited.
     *
     * Parameters:
     * * `InputPeer` **peer** - Peer where the media was sent
     * * `int`       **id**   - ID of message
     *
     * @param array $params Parameters
     *
     * @return messages.MessageEditData
     */
    public function getMessageEditData($params);

    /**
     * Edit message.
     *
     * Parameters:
     * * `boolean`         **no_webpage**    - Optional: Disable webpage preview
     * * `InputPeer`       **peer**          - Where was the message sent
     * * `int`             **id**            - ID of the message to edit
     * * `string`          **message**       - Optional: New message
     * * `InputMedia`      **media**         - Optional: New attached media
     * * `ReplyMarkup`     **reply_markup**  - Optional: Reply markup for inline keyboards
     * * `[MessageEntity]` **entities**      - Optional: [Message entities for styled text](https://core.telegram.org/api/entities)
     * * `int`             **schedule_date** - Optional: Scheduled message date for scheduled messages
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function editMessage($params);

    /**
     * Edit an inline bot message.
     *
     * Parameters:
     * * `boolean`                 **no_webpage**   - Optional: Disable webpage preview
     * * `InputBotInlineMessageID` **id**           - Sent inline message ID
     * * `string`                  **message**      - Optional: Message
     * * `InputMedia`              **media**        - Optional: Media
     * * `ReplyMarkup`             **reply_markup** - Optional: Reply markup for inline keyboards
     * * `[MessageEntity]`         **entities**     - Optional: [Message entities for styled text](https://core.telegram.org/api/entities)
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function editInlineBotMessage($params);

    /**
     * Press an inline callback button and get a callback answer from the bot.
     *
     * Parameters:
     * * `boolean`               **game**     - Optional: Whether this is a "play game" button
     * * `InputPeer`             **peer**     - Where was the inline keyboard sent
     * * `int`                   **msg_id**   - ID of the Message with the inline keyboard
     * * `bytes`                 **data**     - Optional: Callback data
     * * `InputCheckPasswordSRP` **password** - Optional:
     *
     * @param array $params Parameters
     *
     * @return messages.BotCallbackAnswer
     */
    public function getBotCallbackAnswer($params);

    /**
     * Set the callback answer to a user button press (bots only).
     *
     * Parameters:
     * * `boolean` **alert**      - Optional: Whether to show the message as a popup instead of a toast notification
     * * `long`    **query_id**   - Query ID
     * * `string`  **message**    - Optional: Popup to show
     * * `string`  **url**        - Optional: URL to open
     * * `int`     **cache_time** - Cache validity
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setBotCallbackAnswer($params);

    /**
     * Get dialog info of specified peers.
     *
     * Parameters:
     * * `[InputDialogPeer]` **peers** - Peers
     *
     * @param array $params Parameters
     *
     * @return messages.PeerDialogs
     */
    public function getPeerDialogs($params);

    /**
     * Save a message [draft](https://core.telegram.org/api/drafts) associated to a chat.
     *
     * Parameters:
     * * `boolean`         **no_webpage**      - Optional: Disable generation of the webpage preview
     * * `int`             **reply_to_msg_id** - Optional: Message ID the message should reply to
     * * `InputPeer`       **peer**            - Destination of the message that should be sent
     * * `string`          **message**         - The draft
     * * `[MessageEntity]` **entities**        - Optional: Message [entities](https://core.telegram.org/api/entities) for styled text
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function saveDraft($params);

    /**
     * Save get all message [drafts](https://core.telegram.org/api/drafts).
     *
     * @return Updates
     */
    public function getAllDrafts();

    /**
     * Get featured stickers.
     *
     * Parameters:
     * * `[int]` **hash** - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return messages.FeaturedStickers
     */
    public function getFeaturedStickers($params);

    /**
     * Mark new featured stickers as read.
     *
     * Parameters:
     * * `[long]` **id** - IDs of stickersets to mark as read
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function readFeaturedStickers($params);

    /**
     * Get recent stickers.
     *
     * Parameters:
     * * `boolean` **attached** - Optional: Get stickers recently attached to photo or video files
     * * `[int]`   **hash**     - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return messages.RecentStickers
     */
    public function getRecentStickers($params);

    /**
     * Add/remove sticker from recent stickers list.
     *
     * Parameters:
     * * `boolean`       **attached** - Optional: Whether to add/remove stickers recently attached to photo or video files
     * * `InputDocument` **id**       - Sticker
     * * `Bool`          **unsave**   - Whether to save or unsave the sticker
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function saveRecentSticker($params);

    /**
     * Clear recent stickers.
     *
     * Parameters:
     * * `boolean` **attached** - Optional: Set this flag to clear the list of stickers recently attached to photo or video files
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function clearRecentStickers($params);

    /**
     * Get all archived stickers.
     *
     * Parameters:
     * * `boolean` **masks**     - Optional: Get mask stickers
     * * `long`    **offset_id** - [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * * `int`     **limit**     - Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     *
     * @param array $params Parameters
     *
     * @return messages.ArchivedStickers
     */
    public function getArchivedStickers($params);

    /**
     * Get installed mask stickers.
     *
     * Parameters:
     * * `[int]` **hash** - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return messages.AllStickers
     */
    public function getMaskStickers($params);

    /**
     * Get stickers attached to a photo or video.
     *
     * Parameters:
     * * `InputStickeredMedia` **media** - Stickered media
     *
     * @param array $params Parameters
     *
     * @return  of StickerSetCovered[]
     */
    public function getAttachedStickers($params);

    /**
     * Use this method to set the score of the specified user in a game sent as a normal message (bots only).
     *
     * Parameters:
     * * `boolean`   **edit_message** - Optional: Set this flag if the game message should be automatically edited to include the current scoreboard
     * * `boolean`   **force**        - Optional: Set this flag if the high score is allowed to decrease. This can be useful when fixing mistakes or banning cheaters
     * * `InputPeer` **peer**         - Unique identifier of target chat
     * * `int`       **id**           - Identifier of the sent message
     * * `InputUser` **user_id**      - User identifier
     * * `int`       **score**        - New score
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function setGameScore($params);

    /**
     * Use this method to set the score of the specified user in a game sent as an inline message (bots only).
     *
     * Parameters:
     * * `boolean`                 **edit_message** - Optional: Set this flag if the game message should be automatically edited to include the current scoreboard
     * * `boolean`                 **force**        - Optional: Set this flag if the high score is allowed to decrease. This can be useful when fixing mistakes or banning cheaters
     * * `InputBotInlineMessageID` **id**           - ID of the inline message
     * * `InputUser`               **user_id**      - User identifier
     * * `int`                     **score**        - New score
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setInlineGameScore($params);

    /**
     * Get highscores of a game.
     *
     * Parameters:
     * * `InputPeer` **peer**    - Where was the game sent
     * * `int`       **id**      - ID of message with game media attachment
     * * `InputUser` **user_id** - Get high scores made by a certain user
     *
     * @param array $params Parameters
     *
     * @return messages.HighScores
     */
    public function getGameHighScores($params);

    /**
     * Get highscores of a game sent using an inline bot.
     *
     * Parameters:
     * * `InputBotInlineMessageID` **id**      - ID of inline message
     * * `InputUser`               **user_id** - Get high scores of a certain user
     *
     * @param array $params Parameters
     *
     * @return messages.HighScores
     */
    public function getInlineGameHighScores($params);

    /**
     * Get chats in common with a user.
     *
     * Parameters:
     * * `InputUser` **user_id** - User ID
     * * `int`       **max_id**  - Maximum ID of chat to return (see [pagination](https://core.telegram.org/api/offsets))
     * * `int`       **limit**   - Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     *
     * @param array $params Parameters
     *
     * @return messages.Chats
     */
    public function getCommonChats($params);

    /**
     * Get all chats, channels and supergroups.
     *
     * Parameters:
     * * `[int]` **except_ids** - Except these chats/channels/supergroups
     *
     * @param array $params Parameters
     *
     * @return messages.Chats
     */
    public function getAllChats($params);

    /**
     * Get [instant view](https://instantview.telegram.org) page.
     *
     * Parameters:
     * * `string` **url**  - URL of IV page to fetch
     * * `[int]`  **hash** - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return WebPage
     */
    public function getWebPage($params);

    /**
     * Pin/unpin a dialog.
     *
     * Parameters:
     * * `boolean`         **pinned** - Optional: Whether to pin or unpin the dialog
     * * `InputDialogPeer` **peer**   - The dialog to pin
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function toggleDialogPin($params);

    /**
     * Reorder pinned dialogs.
     *
     * Parameters:
     * * `boolean`           **force**     - Optional: If set, dialogs pinned server-side but not present in the `order` field will be unpinned.
     * * `int`               **folder_id** - [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
     * * `[InputDialogPeer]` **order**     - New dialog order
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function reorderPinnedDialogs($params);

    /**
     * Get pinned dialogs.
     *
     * Parameters:
     * * `int` **folder_id** - [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
     *
     * @param array $params Parameters
     *
     * @return messages.PeerDialogs
     */
    public function getPinnedDialogs($params);

    /**
     * If you sent an invoice requesting a shipping address and the parameter is\_flexible was specified, the bot will receive an [updateBotShippingQuery](https://docs.madelineproto.xyz/API_docs/constructors/updateBotShippingQuery.html) update. Use this method to reply to shipping queries.
     *
     * Parameters:
     * * `long`             **query_id**         - Unique identifier for the query to be answered
     * * `string`           **error**            - Optional: Error message in human readable form that explains why it is impossible to complete the order (e.g. "Sorry, delivery to your desired address is unavailable'). Telegram will display this message to the user.
     * * `[ShippingOption]` **shipping_options** - Optional: A vector of available shipping options.
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setBotShippingResults($params);

    /**
     * Once the user has confirmed their payment and shipping details, the bot receives an [updateBotPrecheckoutQuery](https://docs.madelineproto.xyz/API_docs/constructors/updateBotPrecheckoutQuery.html) update.
     * Use this method to respond to such pre-checkout queries.
     * **Note**: Telegram must receive an answer within 10 seconds after the pre-checkout query was sent.
     *
     * Parameters:
     * * `boolean` **success**  - Optional: Set this flag if everything is alright (goods are available, etc.) and the bot is ready to proceed with the order, otherwise do not set it, and set the `error` field, instead
     * * `long`    **query_id** - Unique identifier for the query to be answered
     * * `string`  **error**    - Optional: Required if the `success` isn't set. Error message in human readable form that explains the reason for failure to proceed with the checkout (e.g. "Sorry, somebody just bought the last of our amazing black T-shirts while you were busy filling out your payment details. Please choose a different color or garment!"). Telegram will display this message to the user.
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setBotPrecheckoutResults($params);

    /**
     * Upload a file and associate it to a chat (without actually sending it to the chat).
     *
     * Parameters:
     * * `InputPeer`  **peer**  - The chat, can be an [inputPeerEmpty](https://docs.madelineproto.xyz/API_docs/constructors/inputPeerEmpty.html) for bots
     * * `InputMedia` **media** - File uploaded in chunks as described in [files »](https://core.telegram.org/api/files)
     *
     * @param array $params Parameters
     *
     * @return MessageMedia
     */
    public function uploadMedia($params);

    /**
     * Notify the other user in a private chat that a screenshot of the chat was taken.
     *
     * Parameters:
     * * `InputPeer` **peer**            - Other user
     * * `int`       **reply_to_msg_id** - ID of message that was screenshotted, can be 0
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function sendScreenshotNotification($params);

    /**
     * Get faved stickers.
     *
     * Parameters:
     * * `[int]` **hash** - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return messages.FavedStickers
     */
    public function getFavedStickers($params);

    /**
     * Mark a sticker as favorite.
     *
     * Parameters:
     * * `InputDocument` **id**     - Sticker to mark as favorite
     * * `Bool`          **unfave** - Unfavorite
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function faveSticker($params);

    /**
     * Get unread messages where we were mentioned.
     *
     * Parameters:
     * * `InputPeer` **peer**       - Peer where to look for mentions
     * * `int`       **offset_id**  - [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * * `int`       **add_offset** - [Offsets for pagination, for more info click here](https://core.telegram.org/api/offsets)
     * * `int`       **limit**      - Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * * `int`       **max_id**     - Maximum message ID to return, [see pagination](https://core.telegram.org/api/offsets)
     * * `int`       **min_id**     - Minimum message ID to return, [see pagination](https://core.telegram.org/api/offsets)
     *
     * @param array $params Parameters
     *
     * @return messages.Messages
     */
    public function getUnreadMentions($params);

    /**
     * Mark mentions as read.
     *
     * Parameters:
     * * `InputPeer` **peer** - Dialog
     *
     * @param array $params Parameters
     *
     * @return messages.AffectedHistory
     */
    public function readMentions($params);

    /**
     * Get live location history of a certain user.
     *
     * Parameters:
     * * `InputPeer` **peer**  - User
     * * `int`       **limit** - Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * * `[int]`     **hash**  - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return messages.Messages
     */
    public function getRecentLocations($params);

    /**
     * Send an album of media.
     *
     * Parameters:
     * * `boolean`            **silent**          - Optional: Whether to send the album silently (no notification triggered)
     * * `boolean`            **background**      - Optional: Send in background?
     * * `boolean`            **clear_draft**     - Optional: Whether to clear [drafts](https://core.telegram.org/api/drafts)
     * * `InputPeer`          **peer**            - The destination chat
     * * `int`                **reply_to_msg_id** - Optional: The message to reply to
     * * `[InputSingleMedia]` **multi_media**     - The medias to send
     * * `int`                **schedule_date**   - Optional: Scheduled message date for scheduled messages
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function sendMultiMedia($params);

    /**
     * Upload encrypted file and associate it to a secret chat.
     *
     * Parameters:
     * * `InputEncryptedChat` **peer** - The secret chat to associate the file to
     * * `InputEncryptedFile` **file** - The file
     *
     * @param array $params Parameters
     *
     * @return EncryptedFile
     */
    public function uploadEncryptedFile($params);

    /**
     * Search for stickersets.
     *
     * Parameters:
     * * `boolean` **exclude_featured** - Optional: Exclude featured stickersets from results
     * * `string`  **q**                - Query string
     * * `[int]`   **hash**             - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return messages.FoundStickerSets
     */
    public function searchStickerSets($params);

    /**
     * Get message ranges for saving the user's chat history.
     *
     * @return  of MessageRange[]
     */
    public function getSplitRanges();

    /**
     * Manually mark dialog as unread.
     *
     * Parameters:
     * * `boolean`         **unread** - Optional: Mark as unread/read
     * * `InputDialogPeer` **peer**   - Dialog
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function markDialogUnread($params);

    /**
     * Get dialogs manually marked as unread.
     *
     * @return  of DialogPeer[]
     */
    public function getDialogUnreadMarks();

    /**
     * Clear all [drafts](https://core.telegram.org/api/drafts).
     *
     * @return bool
     */
    public function clearAllDrafts();

    /**
     * Pin a message.
     *
     * Parameters:
     * * `boolean`   **silent**     - Optional: Pin the message silently, without triggering a notification
     * * `boolean`   **unpin**      - Optional:
     * * `boolean`   **pm_oneside** - Optional:
     * * `InputPeer` **peer**       - The peer where to pin the message
     * * `int`       **id**         - The message to pin, can be 0 to unpin any currently pinned messages
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function updatePinnedMessage($params);

    /**
     * Vote in a [poll](https://docs.madelineproto.xyz/API_docs/constructors/poll.html).
     *
     * Parameters:
     * * `InputPeer` **peer**    - The chat where the poll was sent
     * * `int`       **msg_id**  - The message ID of the poll
     * * `[bytes]`   **options** - The options that were chosen
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function sendVote($params);

    /**
     * Get poll results.
     *
     * Parameters:
     * * `InputPeer` **peer**   - Peer where the poll was found
     * * `int`       **msg_id** - Message ID of poll message
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function getPollResults($params);

    /**
     * Get count of online users in a chat.
     *
     * Parameters:
     * * `InputPeer` **peer** - The chat
     *
     * @param array $params Parameters
     *
     * @return ChatOnlines
     */
    public function getOnlines($params);

    /**
     * Returns URL with the chat statistics. Currently this method can be used only for channels.
     *
     * Parameters:
     * * `boolean`   **dark**   - Optional: Pass true if a URL with the dark theme must be returned
     * * `InputPeer` **peer**   - Chat identifier
     * * `string`    **params** - Parameters from `tg://statsrefresh?params=******` link
     *
     * @param array $params Parameters
     *
     * @return StatsURL
     */
    public function getStatsURL($params);

    /**
     * Edit the description of a [group/supergroup/channel](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputPeer` **peer**  - The [group/supergroup/channel](https://core.telegram.org/api/channel).
     * * `string`    **about** - The new description
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function editChatAbout($params);

    /**
     * Edit the default banned rights of a [channel/supergroup/group](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputPeer`        **peer**          - The peer
     * * `ChatBannedRights` **banned_rights** - The new global rights
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function editChatDefaultBannedRights($params);

    /**
     * Get localized emoji keywords.
     *
     * Parameters:
     * * `string` **lang_code** - Language code
     *
     * @param array $params Parameters
     *
     * @return EmojiKeywordsDifference
     */
    public function getEmojiKeywords($params);

    /**
     * Get changed emoji keywords.
     *
     * Parameters:
     * * `string` **lang_code**    - Language code
     * * `int`    **from_version** - Previous emoji keyword localization version
     *
     * @param array $params Parameters
     *
     * @return EmojiKeywordsDifference
     */
    public function getEmojiKeywordsDifference($params);

    /**
     * Get info about an emoji keyword localization.
     *
     * Parameters:
     * * `[string]` **lang_codes** - Language codes
     *
     * @param array $params Parameters
     *
     * @return  of EmojiLanguage[]
     */
    public function getEmojiKeywordsLanguages($params);

    /**
     * Returns an HTTP URL which can be used to automatically log in into translation platform and suggest new emoji replacements. The URL will be valid for 30 seconds after generation.
     *
     * Parameters:
     * * `string` **lang_code** - Language code for which the emoji replacements will be suggested
     *
     * @param array $params Parameters
     *
     * @return EmojiURL
     */
    public function getEmojiURL($params);

    /**
     * Get the number of results that would be found by a [messages.search](https://docs.madelineproto.xyz/API_docs/methods/messages.search.html) call with the same parameters.
     *
     * Parameters:
     * * `InputPeer`        **peer**    - Peer where to search
     * * `[MessagesFilter]` **filters** - Search filters
     *
     * @param array $params Parameters
     *
     * @return  of messages.SearchCounter[]
     */
    public function getSearchCounters($params);

    /**
     * Get more info about a Seamless Telegram Login authorization request, for more info [click here »](https://core.telegram.org/api/url-authorization).
     *
     * Parameters:
     * * `InputPeer` **peer**      - Peer where the message is located
     * * `int`       **msg_id**    - The message
     * * `int`       **button_id** - The ID of the button with the authorization request
     *
     * @param array $params Parameters
     *
     * @return UrlAuthResult
     */
    public function requestUrlAuth($params);

    /**
     * Use this to accept a Seamless Telegram Login authorization request, for more info [click here »](https://core.telegram.org/api/url-authorization).
     *
     * Parameters:
     * * `boolean`   **write_allowed** - Optional: Set this flag to allow the bot to send messages to you (if requested)
     * * `InputPeer` **peer**          - The location of the message
     * * `int`       **msg_id**        - Message ID of the message with the login button
     * * `int`       **button_id**     - ID of the login button
     *
     * @param array $params Parameters
     *
     * @return UrlAuthResult
     */
    public function acceptUrlAuth($params);

    /**
     * Should be called after the user hides the report spam/add as contact bar of a new chat, effectively prevents the user from executing the actions specified in the [peer's settings](https://docs.madelineproto.xyz/API_docs/constructors/peerSettings.html).
     *
     * Parameters:
     * * `InputPeer` **peer** - Peer
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function hidePeerSettingsBar($params);

    /**
     * Get scheduled messages.
     *
     * Parameters:
     * * `InputPeer` **peer** - Peer
     * * `[int]`     **hash** - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return messages.Messages
     */
    public function getScheduledHistory($params);

    /**
     * Get scheduled messages.
     *
     * Parameters:
     * * `InputPeer` **peer** - Peer
     * * `[int]`     **id**   - IDs of scheduled messages
     *
     * @param array $params Parameters
     *
     * @return messages.Messages
     */
    public function getScheduledMessages($params);

    /**
     * Send scheduled messages right away.
     *
     * Parameters:
     * * `InputPeer` **peer** - Peer
     * * `[int]`     **id**   - Scheduled message IDs
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function sendScheduledMessages($params);

    /**
     * Delete scheduled messages.
     *
     * Parameters:
     * * `InputPeer` **peer** - Peer
     * * `[int]`     **id**   - Scheduled message IDs
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function deleteScheduledMessages($params);

    /**
     * Get poll results for non-anonymous polls.
     *
     * Parameters:
     * * `InputPeer` **peer**   - Chat where the poll was sent
     * * `int`       **id**     - Message ID
     * * `bytes`     **option** - Optional: Get only results for the specified poll `option`
     * * `string`    **offset** - Optional: Offset for results, taken from the `next_offset` field of [messages.votesList](https://docs.madelineproto.xyz/API_docs/constructors/messages.votesList.html), initially an empty string. <br>Note: if no more results are available, the method call will return an empty `next_offset`; thus, avoid providing the `next_offset` returned in [messages.votesList](https://docs.madelineproto.xyz/API_docs/constructors/messages.votesList.html) if it is empty, to avoid an infinite loop.
     * * `int`       **limit**  - Number of results to return
     *
     * @param array $params Parameters
     *
     * @return messages.VotesList
     */
    public function getPollVotes($params);

    /**
     * Apply changes to multiple stickersets.
     *
     * Parameters:
     * * `boolean`           **uninstall**   - Optional: Uninstall the specified stickersets
     * * `boolean`           **archive**     - Optional: Archive the specified stickersets
     * * `boolean`           **unarchive**   - Optional: Unarchive the specified stickersets
     * * `[InputStickerSet]` **stickersets** - Stickersets to act upon
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function toggleStickerSets($params);

    /**
     * Get [folders](https://core.telegram.org/api/folders).
     *
     * @return  of DialogFilter[]
     */
    public function getDialogFilters();

    /**
     * Get [suggested folders](https://core.telegram.org/api/folders).
     *
     * @return  of DialogFilterSuggested[]
     */
    public function getSuggestedDialogFilters();

    /**
     * Update [folder](https://core.telegram.org/api/folders).
     *
     * Parameters:
     * * `int`          **id**     - [Folder](https://core.telegram.org/api/folders) ID
     * * `DialogFilter` **filter** - Optional: [Folder](https://core.telegram.org/api/folders) info
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function updateDialogFilter($params);

    /**
     * Reorder [folders](https://core.telegram.org/api/folders).
     *
     * Parameters:
     * * `[int]` **order** - New [folder](https://core.telegram.org/api/folders) order
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function updateDialogFiltersOrder($params);

    /**
     * Method for fetching previously featured stickers.
     *
     * Parameters:
     * * `int`   **offset** - Offset
     * * `int`   **limit**  - Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     * * `[int]` **hash**   - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return messages.FeaturedStickers
     */
    public function getOldFeaturedStickers($params);

    /**
     *
     *
     * Parameters:
     * * `InputPeer` **peer**        -
     * * `int`       **msg_id**      -
     * * `int`       **offset_id**   -
     * * `int`       **offset_date** -
     * * `int`       **add_offset**  -
     * * `int`       **limit**       -
     * * `int`       **max_id**      -
     * * `int`       **min_id**      -
     * * `[int]`     **hash**        - Optional:.
     *
     * @param array $params Parameters
     *
     * @return messages.Messages
     */
    public function getReplies($params);

    /**
     *
     *
     * Parameters:
     * * `InputPeer` **peer**   -
     * * `int`       **msg_id** -.
     *
     * @param array $params Parameters
     *
     * @return messages.DiscussionMessage
     */
    public function getDiscussionMessage($params);

    /**
     *
     *
     * Parameters:
     * * `InputPeer` **peer**        -
     * * `int`       **msg_id**      -
     * * `int`       **read_max_id** -.
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function readDiscussion($params);

    /**
     *
     *
     * Parameters:
     * * `InputPeer` **peer** -.
     *
     * @param array $params Parameters
     *
     * @return messages.AffectedHistory
     */
    public function unpinAllMessages($params);
}

interface updates
{
    /**
     * Returns a current state of updates.
     *
     * @return updates.State
     */
    public function getState();

    /**
     * Get new [updates](https://core.telegram.org/api/updates).
     *
     * Parameters:
     * * `int` **pts**             - PTS, see [updates](https://core.telegram.org/api/updates).
     * * `int` **pts_total_limit** - Optional: For fast updating: if provided and `pts + pts_total_limit < remote pts`, [updates.differenceTooLong](https://docs.madelineproto.xyz/API_docs/constructors/updates.differenceTooLong.html) will be returned.<br>Simply tells the server to not return the difference if it is bigger than `pts_total_limit`<br>If the remote pts is too big (&gt; ~4000000), this field will default to 1000000
     * * `int` **date**            - date, see [updates](https://core.telegram.org/api/updates).
     * * `int` **qts**             - QTS, see [updates](https://core.telegram.org/api/updates).
     *
     * @param array $params Parameters
     *
     * @return updates.Difference
     */
    public function getDifference($params);

    /**
     * Returns the difference between the current state of updates of a certain channel and transmitted.
     *
     * Parameters:
     * * `boolean`               **force**   - Optional: Set to true to skip some possibly unneeded updates and reduce server-side load
     * * `InputChannel`          **channel** - The channel
     * * `ChannelMessagesFilter` **filter**  - Messsage filter
     * * `int`                   **pts**     - Persistent timestamp (see [updates](https://core.telegram.org/api/updates))
     * * `int`                   **limit**   - How many updates to fetch, max `100000`<br>Ordinary (non-bot) users are supposed to pass `10-100`
     *
     * @param array $params Parameters
     *
     * @return updates.ChannelDifference
     */
    public function getChannelDifference($params);
}

interface photos
{
    /**
     * Installs a previously uploaded photo as a profile photo.
     *
     * Parameters:
     * * `InputPhoto` **id** - Input photo
     *
     * @param array $params Parameters
     *
     * @return photos.Photo
     */
    public function updateProfilePhoto($params);

    /**
     * Updates current user profile photo.
     *
     * Parameters:
     * * `InputFile` **file**           - Optional: File saved in parts by means of [upload.saveFilePart](https://docs.madelineproto.xyz/API_docs/methods/upload.saveFilePart.html) method
     * * `InputFile` **video**          - Optional:
     * * `double`    **video_start_ts** - Optional:
     *
     * @param array $params Parameters
     *
     * @return photos.Photo
     */
    public function uploadProfilePhoto($params);

    /**
     * Deletes profile photos.
     *
     * Parameters:
     * * `[InputPhoto]` **id** - Input photos to delete
     *
     * @param array $params Parameters
     *
     * @return  of long[]
     */
    public function deletePhotos($params);

    /**
     * Returns the list of user photos.
     *
     * Parameters:
     * * `InputUser` **user_id** - User ID
     * * `int`       **offset**  - Number of list elements to be skipped
     * * `long`      **max_id**  - If a positive value was transferred, the method will return only photos with IDs less than the set one
     * * `int`       **limit**   - Number of list elements to be returned
     *
     * @param array $params Parameters
     *
     * @return photos.Photos
     */
    public function getUserPhotos($params);
}

interface upload
{
    /**
     * Saves a part of file for futher sending to one of the methods.
     *
     * Parameters:
     * * `long`  **file_id**   - Random file identifier created by the client
     * * `int`   **file_part** - Numerical order of a part
     * * `bytes` **bytes**     - Binary data, contend of a part
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function saveFilePart($params);

    /**
     * Returns content of a whole file or its part.
     *
     * Parameters:
     * * `boolean`           **precise**       - Optional: Disable some checks on limit and offset values, useful for example to stream videos by keyframes
     * * `boolean`           **cdn_supported** - Optional: Whether the current client supports [CDN downloads](https://core.telegram.org/cdn)
     * * `InputFileLocation` **location**      - File location
     * * `int`               **offset**        - Number of bytes to be skipped
     * * `int`               **limit**         - Number of bytes to be returned
     *
     * @param array $params Parameters
     *
     * @return upload.File
     */
    public function getFile($params);

    /**
     * Saves a part of a large file (over 10Mb in size) to be later passed to one of the methods.
     *
     * Parameters:
     * * `long`  **file_id**          - Random file id, created by the client
     * * `int`   **file_part**        - Part sequence number
     * * `int`   **file_total_parts** - Total number of parts
     * * `bytes` **bytes**            - Binary data, part contents
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function saveBigFilePart($params);

    /**
     * Returns content of an HTTP file or a part, by proxying the request through telegram.
     *
     * Parameters:
     * * `InputWebFileLocation` **location** - The file to download
     * * `int`                  **offset**   - Number of bytes to be skipped
     * * `int`                  **limit**    - Number of bytes to be returned
     *
     * @param array $params Parameters
     *
     * @return upload.WebFile
     */
    public function getWebFile($params);

    /**
     * Download a [CDN](https://core.telegram.org/cdn) file.
     *
     * Parameters:
     * * `bytes` **file_token** - File token
     * * `int`   **offset**     - Offset of chunk to download
     * * `int`   **limit**      - Length of chunk to download
     *
     * @param array $params Parameters
     *
     * @return upload.CdnFile
     */
    public function getCdnFile($params);

    /**
     * Request a reupload of a certain file to a [CDN DC](https://core.telegram.org/cdn).
     *
     * Parameters:
     * * `bytes` **file_token**    - File token
     * * `bytes` **request_token** - Request token
     *
     * @param array $params Parameters
     *
     * @return  of FileHash[]
     */
    public function reuploadCdnFile($params);

    /**
     * Get SHA256 hashes for verifying downloaded [CDN](https://core.telegram.org/cdn) files.
     *
     * Parameters:
     * * `bytes` **file_token** - File
     * * `int`   **offset**     - Offset from which to start getting hashes
     *
     * @param array $params Parameters
     *
     * @return  of FileHash[]
     */
    public function getCdnFileHashes($params);

    /**
     * Get SHA256 hashes for verifying downloaded files.
     *
     * Parameters:
     * * `InputFileLocation` **location** - File
     * * `int`               **offset**   - Offset from which to get file hashes
     *
     * @param array $params Parameters
     *
     * @return  of FileHash[]
     */
    public function getFileHashes($params);
}

interface help
{
    /**
     * Returns current configuration, including data center configuration.
     *
     * @return Config
     */
    public function getConfig();

    /**
     * Returns info on data centre nearest to the user.
     *
     * @return NearestDc
     */
    public function getNearestDc();

    /**
     * Returns information on update availability for the current application.
     *
     * Parameters:
     * * `string` **source** - Source
     *
     * @param array $params Parameters
     *
     * @return help.AppUpdate
     */
    public function getAppUpdate($params);

    /**
     * Returns localized text of a text message with an invitation.
     *
     * @return help.InviteText
     */
    public function getInviteText();

    /**
     * Returns the support user for the 'ask a question' feature.
     *
     * @return help.Support
     */
    public function getSupport();

    /**
     * Get changelog of current app.
     * Typically, an [updates](https://docs.madelineproto.xyz/API_docs/constructors/updates.html) constructor will be returned, containing one or more [updateServiceNotification](https://docs.madelineproto.xyz/API_docs/constructors/updateServiceNotification.html) updates with app-specific changelogs.
     *
     * Parameters:
     * * `string` **prev_app_version** - Previous app version
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function getAppChangelog($params);

    /**
     * Informs the server about the number of pending bot updates if they haven't been processed for a long time; for bots only.
     *
     * Parameters:
     * * `int`    **pending_updates_count** - Number of pending updates
     * * `string` **message**               - Error message, if present
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setBotUpdatesStatus($params);

    /**
     * Get configuration for [CDN](https://core.telegram.org/cdn) file downloads.
     *
     * @return CdnConfig
     */
    public function getCdnConfig();

    /**
     * Get recently used `t.me` links.
     *
     * Parameters:
     * * `string` **referer** - Referer
     *
     * @param array $params Parameters
     *
     * @return help.RecentMeUrls
     */
    public function getRecentMeUrls($params);

    /**
     * Look for updates of telegram's terms of service.
     *
     * @return help.TermsOfServiceUpdate
     */
    public function getTermsOfServiceUpdate();

    /**
     * Accept the new terms of service.
     *
     * Parameters:
     * * `DataJSON` **id** - ID of terms of service
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function acceptTermsOfService($params);

    /**
     * Get info about a `t.me` link.
     *
     * Parameters:
     * * `string` **path** - Path in `t.me/path`
     *
     * @param array $params Parameters
     *
     * @return help.DeepLinkInfo
     */
    public function getDeepLinkInfo($params);

    /**
     * Get app-specific configuration, see [client configuration](https://core.telegram.org/api/config#client-configuration) for more info on the result.
     *
     * @return JSONValue
     */
    public function getAppConfig();

    /**
     * Saves logs of application on the server.
     *
     * Parameters:
     * * `[InputAppEvent]` **events** - List of input events
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function saveAppLog($params);

    /**
     * Get [passport](https://core.telegram.org/passport) configuration.
     *
     * Parameters:
     * * `[int]` **hash** - Optional: [Hash for pagination, for more info click here](https://core.telegram.org/api/offsets#hash-generation)
     *
     * @param array $params Parameters
     *
     * @return help.PassportConfig
     */
    public function getPassportConfig($params);

    /**
     * Get localized name of the telegram support user.
     *
     * @return help.SupportName
     */
    public function getSupportName();

    /**
     * Internal use.
     *
     * Parameters:
     * * `InputUser` **user_id** - User ID
     *
     * @param array $params Parameters
     *
     * @return help.UserInfo
     */
    public function getUserInfo($params);

    /**
     * Internal use.
     *
     * Parameters:
     * * `InputUser`       **user_id**  - User
     * * `string`          **message**  - Message
     * * `[MessageEntity]` **entities** - [Message entities for styled text](https://core.telegram.org/api/entities)
     *
     * @param array $params Parameters
     *
     * @return help.UserInfo
     */
    public function editUserInfo($params);

    /**
     * Get MTProxy/Public Service Announcement information.
     *
     * @return help.PromoData
     */
    public function getPromoData();

    /**
     * Hide MTProxy/Public Service Announcement information.
     *
     * Parameters:
     * * `InputPeer` **peer** - Peer to hide
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function hidePromoData($params);

    /**
     *
     *
     * Parameters:
     * * `string` **suggestion** -.
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function dismissSuggestion($params);

    /**
     *
     *
     * Parameters:
     * * `string` **lang_code** -
     * * `[int]`  **hash**      - Optional:.
     *
     * @param array $params Parameters
     *
     * @return help.CountriesList
     */
    public function getCountriesList($params);
}

interface channels
{
    /**
     * Mark [channel/supergroup](https://core.telegram.org/api/channel) history as read.
     *
     * Parameters:
     * * `InputChannel` **channel** - [Channel/supergroup](https://core.telegram.org/api/channel)
     * * `int`          **max_id**  - ID of message up to which messages should be marked as read
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function readHistory($params);

    /**
     * Delete messages in a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputChannel` **channel** - [Channel/supergroup](https://core.telegram.org/api/channel)
     * * `[int]`        **id**      - IDs of messages to delete
     *
     * @param array $params Parameters
     *
     * @return messages.AffectedMessages
     */
    public function deleteMessages($params);

    /**
     * Delete all messages sent by a certain user in a [supergroup](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputChannel` **channel** - [Supergroup](https://core.telegram.org/api/channel)
     * * `InputUser`    **user_id** - User whose messages should be deleted
     *
     * @param array $params Parameters
     *
     * @return messages.AffectedHistory
     */
    public function deleteUserHistory($params);

    /**
     * Reports some messages from a user in a supergroup as spam; requires administrator rights in the supergroup.
     *
     * Parameters:
     * * `InputChannel` **channel** - Supergroup
     * * `InputUser`    **user_id** - ID of the user that sent the spam messages
     * * `[int]`        **id**      - IDs of spam messages
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function reportSpam($params);

    /**
     * Get [channel/supergroup](https://core.telegram.org/api/channel) messages.
     *
     * Parameters:
     * * `InputChannel`   **channel** - Channel/supergroup
     * * `[InputMessage]` **id**      - IDs of messages to get
     *
     * @param array $params Parameters
     *
     * @return messages.Messages
     */
    public function getMessages($params);

    /**
     * Get the participants of a [supergroup/channel](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputChannel`              **channel** - Channel
     * * `ChannelParticipantsFilter` **filter**  - Which participant types to fetch
     * * `int`                       **offset**  - [Offset](https://core.telegram.org/api/offsets)
     * * `int`                       **limit**   - [Limit](https://core.telegram.org/api/offsets)
     * * `[int]`                     **hash**    - Optional: [Hash](https://core.telegram.org/api/offsets)
     *
     * @param array $params Parameters
     *
     * @return channels.ChannelParticipants
     */
    public function getParticipants($params);

    /**
     * Get info about a [channel/supergroup](https://core.telegram.org/api/channel) participant.
     *
     * Parameters:
     * * `InputChannel` **channel** - Channel/supergroup
     * * `InputUser`    **user_id** - ID of participant to get info about
     *
     * @param array $params Parameters
     *
     * @return channels.ChannelParticipant
     */
    public function getParticipant($params);

    /**
     * Get info about [channels/supergroups](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `[InputChannel]` **id** - IDs of channels/supergroups to get info about
     *
     * @param array $params Parameters
     *
     * @return messages.Chats
     */
    public function getChannels($params);

    /**
     * Get full info about a channel.
     *
     * Parameters:
     * * `InputChannel` **channel** - The channel to get info about
     *
     * @param array $params Parameters
     *
     * @return messages.ChatFull
     */
    public function getFullChannel($params);

    /**
     * Create a [supergroup/channel](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `boolean`       **broadcast** - Optional: Whether to create a [channel](https://core.telegram.org/api/channel)
     * * `boolean`       **megagroup** - Optional: Whether to create a [supergroup](https://core.telegram.org/api/channel)
     * * `string`        **title**     - Channel title
     * * `string`        **about**     - Channel description
     * * `InputGeoPoint` **geo_point** - Optional: Geogroup location
     * * `string`        **address**   - Optional: Geogroup address
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function createChannel($params);

    /**
     * Modify the admin rights of a user in a [supergroup/channel](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputChannel`    **channel**      - The [supergroup/channel](https://core.telegram.org/api/channel).
     * * `InputUser`       **user_id**      - The ID of the user whose admin rights should be modified
     * * `ChatAdminRights` **admin_rights** - The admin rights
     * * `string`          **rank**         - Indicates the role (rank) of the admin in the group: just an arbitrary string
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function editAdmin($params);

    /**
     * Edit the name of a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputChannel` **channel** - Channel/supergroup
     * * `string`       **title**   - New name
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function editTitle($params);

    /**
     * Change the photo of a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputChannel`   **channel** - Channel/supergroup whose photo should be edited
     * * `InputChatPhoto` **photo**   - New photo
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function editPhoto($params);

    /**
     * Check if a username is free and can be assigned to a channel/supergroup.
     *
     * Parameters:
     * * `InputChannel` **channel**  - The [channel/supergroup](https://core.telegram.org/api/channel) that will assigned the specified username
     * * `string`       **username** - The username to check
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function checkUsername($params);

    /**
     * Change the username of a supergroup/channel.
     *
     * Parameters:
     * * `InputChannel` **channel**  - Channel
     * * `string`       **username** - New username
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function updateUsername($params);

    /**
     * Join a channel/supergroup.
     *
     * Parameters:
     * * `InputChannel` **channel** - Channel/supergroup to join
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function joinChannel($params);

    /**
     * Leave a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputChannel` **channel** - [Channel/supergroup](https://core.telegram.org/api/channel) to leave
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function leaveChannel($params);

    /**
     * Invite users to a channel/supergroup.
     *
     * Parameters:
     * * `InputChannel` **channel** - Channel/supergroup
     * * `[InputUser]`  **users**   - Users to invite
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function inviteToChannel($params);

    /**
     * Delete a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputChannel` **channel** - [Channel/supergroup](https://core.telegram.org/api/channel) to delete
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function deleteChannel($params);

    /**
     * Get link and embed info of a message in a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `boolean`      **grouped** - Optional:
     * * `boolean`      **thread**  - Optional:
     * * `InputChannel` **channel** - Channel
     * * `int`          **id**      - Message ID
     *
     * @param array $params Parameters
     *
     * @return ExportedMessageLink
     */
    public function exportMessageLink($params);

    /**
     * Enable/disable message signatures in channels.
     *
     * Parameters:
     * * `InputChannel` **channel** - Channel
     * * `Bool`         **enabled** - Value
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function toggleSignatures($params);

    /**
     * Get [channels/supergroups/geogroups](https://core.telegram.org/api/channel) we're admin in. Usually called when the user exceeds the [limit](https://docs.madelineproto.xyz/API_docs/constructors/config.html) for owned public [channels/supergroups/geogroups](https://core.telegram.org/api/channel), and the user is given the choice to remove one of his channels/supergroups/geogroups.
     *
     * Parameters:
     * * `boolean` **by_location** - Optional: Get geogroups
     * * `boolean` **check_limit** - Optional: If set and the user has reached the limit of owned public [channels/supergroups/geogroups](https://core.telegram.org/api/channel), instead of returning the channel list one of the specified [errors](#possible-errors) will be returned.<br>Useful to check if a new public channel can indeed be created, even before asking the user to enter a channel username to use in [channels.checkUsername](https://docs.madelineproto.xyz/API_docs/methods/channels.checkUsername.html)/[channels.updateUsername](https://docs.madelineproto.xyz/API_docs/methods/channels.updateUsername.html).
     *
     * @param array $params Parameters
     *
     * @return messages.Chats
     */
    public function getAdminedPublicChannels($params);

    /**
     * Ban/unban/kick a user in a [supergroup/channel](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputChannel`     **channel**       - The [supergroup/channel](https://core.telegram.org/api/channel).
     * * `InputUser`        **user_id**       - The ID of the user whose banned rights should be modified
     * * `ChatBannedRights` **banned_rights** - The banned rights
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function editBanned($params);

    /**
     * Get the admin log of a [channel/supergroup](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputChannel`                **channel**       - Channel
     * * `string`                      **q**             - Search query, can be empty
     * * `ChannelAdminLogEventsFilter` **events_filter** - Optional: Event filter
     * * `[InputUser]`                 **admins**        - Optional: Only show events from these admins
     * * `long`                        **max_id**        - Maximum ID of message to return (see [pagination](https://core.telegram.org/api/offsets))
     * * `long`                        **min_id**        - Minimum ID of message to return (see [pagination](https://core.telegram.org/api/offsets))
     * * `int`                         **limit**         - Maximum number of results to return, [see pagination](https://core.telegram.org/api/offsets)
     *
     * @param array $params Parameters
     *
     * @return channels.AdminLogResults
     */
    public function getAdminLog($params);

    /**
     * Associate a stickerset to the supergroup.
     *
     * Parameters:
     * * `InputChannel`    **channel**    - Supergroup
     * * `InputStickerSet` **stickerset** - The stickerset to associate
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setStickers($params);

    /**
     * Mark [channel/supergroup](https://core.telegram.org/api/channel) message contents as read.
     *
     * Parameters:
     * * `InputChannel` **channel** - [Channel/supergroup](https://core.telegram.org/api/channel)
     * * `[int]`        **id**      - IDs of messages whose contents should be marked as read
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function readMessageContents($params);

    /**
     * Delete the history of a [supergroup](https://core.telegram.org/api/channel).
     *
     * Parameters:
     * * `InputChannel` **channel** - [Supergroup](https://core.telegram.org/api/channel) whose history must be deleted
     * * `int`          **max_id**  - ID of message **up to which** the history must be deleted
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function deleteHistory($params);

    /**
     * Hide/unhide message history for new channel/supergroup users.
     *
     * Parameters:
     * * `InputChannel` **channel** - Channel/supergroup
     * * `Bool`         **enabled** - Hide/unhide
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function togglePreHistoryHidden($params);

    /**
     * Get a list of [channels/supergroups](https://core.telegram.org/api/channel) we left.
     *
     * Parameters:
     * * `int` **offset** - Offset for [pagination](https://core.telegram.org/api/offsets)
     *
     * @param array $params Parameters
     *
     * @return messages.Chats
     */
    public function getLeftChannels($params);

    /**
     * Get all groups that can be used as [discussion groups](https://telegram.org/blog/privacy-discussions-web-bots).
     *
     * @return messages.Chats
     */
    public function getGroupsForDiscussion();

    /**
     * Associate a group to a channel as [discussion group](https://telegram.org/blog/privacy-discussions-web-bots) for that channel.
     *
     * Parameters:
     * * `InputChannel` **broadcast** - Channel
     * * `InputChannel` **group**     - Discussion group to associate to the channel
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setDiscussionGroup($params);

    /**
     * Transfer channel ownership.
     *
     * Parameters:
     * * `InputChannel`          **channel**  - Channel
     * * `InputUser`             **user_id**  - New channel owner
     * * `InputCheckPasswordSRP` **password** - [2FA password](https://core.telegram.org/api/srp) of account
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function editCreator($params);

    /**
     * Edit location of geogroup.
     *
     * Parameters:
     * * `InputChannel`  **channel**   - [Geogroup](https://core.telegram.org/api/channel)
     * * `InputGeoPoint` **geo_point** - New geolocation
     * * `string`        **address**   - Address string
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function editLocation($params);

    /**
     * Toggle supergroup slow mode: if enabled, users will only be able to send one message every `seconds` seconds.
     *
     * Parameters:
     * * `InputChannel` **channel** - The [supergroup](https://core.telegram.org/api/channel)
     * * `int`          **seconds** - Users will only be able to send one message every `seconds` seconds, `0` to disable the limitation
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function toggleSlowMode($params);

    /**
     * Get inactive channels and supergroups.
     *
     * @return messages.InactiveChats
     */
    public function getInactiveChannels();
}

interface bots
{
    /**
     * Sends a custom request; for bots only.
     *
     * Parameters:
     * * `string`   **custom_method** - The method name
     * * `DataJSON` **params**        - JSON-serialized method parameters
     *
     * @param array $params Parameters
     *
     * @return DataJSON
     */
    public function sendCustomRequest($params);

    /**
     * Answers a custom query; for bots only.
     *
     * Parameters:
     * * `long`     **query_id** - Identifier of a custom query
     * * `DataJSON` **data**     - JSON-serialized answer to the query
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function answerWebhookJSONQuery($params);

    /**
     * Set bot command list.
     *
     * Parameters:
     * * `[BotCommand]` **commands** - Bot commands
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function setBotCommands($params);
}

interface payments
{
    /**
     * Get a payment form.
     *
     * Parameters:
     * * `int` **msg_id** - Message ID of payment form
     *
     * @param array $params Parameters
     *
     * @return payments.PaymentForm
     */
    public function getPaymentForm($params);

    /**
     * Get payment receipt.
     *
     * Parameters:
     * * `int` **msg_id** - Message ID of receipt
     *
     * @param array $params Parameters
     *
     * @return payments.PaymentReceipt
     */
    public function getPaymentReceipt($params);

    /**
     * Submit requested order information for validation.
     *
     * Parameters:
     * * `boolean`              **save**   - Optional: Save order information to re-use it for future orders
     * * `int`                  **msg_id** - Message ID of payment form
     * * `PaymentRequestedInfo` **info**   - Requested order information
     *
     * @param array $params Parameters
     *
     * @return payments.ValidatedRequestedInfo
     */
    public function validateRequestedInfo($params);

    /**
     * Send compiled payment form.
     *
     * Parameters:
     * * `int`                     **msg_id**             - Message ID of form
     * * `string`                  **requested_info_id**  - Optional: ID of saved and validated [order info](https://docs.madelineproto.xyz/API_docs/constructors/payments.validatedRequestedInfo.html)
     * * `string`                  **shipping_option_id** - Optional: Chosen shipping option ID
     * * `InputPaymentCredentials` **credentials**        - Payment credentials
     *
     * @param array $params Parameters
     *
     * @return payments.PaymentResult
     */
    public function sendPaymentForm($params);

    /**
     * Get saved payment information.
     *
     * @return payments.SavedInfo
     */
    public function getSavedInfo();

    /**
     * Clear saved payment information.
     *
     * Parameters:
     * * `boolean` **credentials** - Optional: Remove saved payment credentials
     * * `boolean` **info**        - Optional: Clear the last order settings saved by the user
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function clearSavedInfo($params);

    /**
     * Get info about a credit card.
     *
     * Parameters:
     * * `string` **number** - Credit card number
     *
     * @param array $params Parameters
     *
     * @return payments.BankCardData
     */
    public function getBankCardData($params);
}

interface stickers
{
    /**
     * Create a stickerset, bots only.
     *
     * Parameters:
     * * `boolean`               **masks**      - Optional: Whether this is a mask stickerset
     * * `boolean`               **animated**   - Optional: Whether this is an animated stickerset
     * * `InputUser`             **user_id**    - Stickerset owner
     * * `string`                **title**      - Stickerset name, `1-64` chars
     * * `string`                **short_name** - Sticker set name. Can contain only English letters, digits and underscores. Must end with *"*by*<bot username="">"</bot>* (*<bot_username></bot_username>* is case insensitive); 1-64 characters
     * * `InputDocument`         **thumb**      - Optional: Thumbnail
     * * `[InputStickerSetItem]` **stickers**   - Stickers
     *
     * @param array $params Parameters
     *
     * @return messages.StickerSet
     */
    public function createStickerSet($params);

    /**
     * Remove a sticker from the set where it belongs, bots only. The sticker set must have been created by the bot.
     *
     * Parameters:
     * * `InputDocument` **sticker** - The sticker to remove
     *
     * @param array $params Parameters
     *
     * @return messages.StickerSet
     */
    public function removeStickerFromSet($params);

    /**
     * Changes the absolute position of a sticker in the set to which it belongs; for bots only. The sticker set must have been created by the bot.
     *
     * Parameters:
     * * `InputDocument` **sticker**  - The sticker
     * * `int`           **position** - The new position of the sticker, zero-based
     *
     * @param array $params Parameters
     *
     * @return messages.StickerSet
     */
    public function changeStickerPosition($params);

    /**
     * Add a sticker to a stickerset, bots only. The sticker set must have been created by the bot.
     *
     * Parameters:
     * * `InputStickerSet`     **stickerset** - The stickerset
     * * `InputStickerSetItem` **sticker**    - The sticker
     *
     * @param array $params Parameters
     *
     * @return messages.StickerSet
     */
    public function addStickerToSet($params);

    /**
     * Set stickerset thumbnail.
     *
     * Parameters:
     * * `InputStickerSet` **stickerset** - Stickerset
     * * `InputDocument`   **thumb**      - Thumbnail
     *
     * @param array $params Parameters
     *
     * @return messages.StickerSet
     */
    public function setStickerSetThumb($params);
}

interface phone
{
    /**
     * Get phone call configuration to be passed to libtgvoip's shared config.
     *
     * @return DataJSON
     */
    public function getCallConfig();

    /**
     * Start a telegram phone call.
     *
     * Parameters:
     * * `boolean`           **video**    - Optional: Whether to start a video call
     * * `InputUser`         **user_id**  - Destination of the phone call
     * * `bytes`             **g_a_hash** - [Parameter for E2E encryption key exchange »](https://core.telegram.org/api/end-to-end/voice-calls)
     * * `PhoneCallProtocol` **protocol** - Phone call settings
     *
     * @param array $params Parameters
     *
     * @return phone.PhoneCall
     */
    public function requestCall($params);

    /**
     * Accept incoming call.
     *
     * Parameters:
     * * `InputPhoneCall`    **peer**     - The call to accept
     * * `bytes`             **g_b**      - [Parameter for E2E encryption key exchange »](https://core.telegram.org/api/end-to-end/voice-calls)
     * * `PhoneCallProtocol` **protocol** - Phone call settings
     *
     * @param array $params Parameters
     *
     * @return phone.PhoneCall
     */
    public function acceptCall($params);

    /**
     * [Complete phone call E2E encryption key exchange »](https://core.telegram.org/api/end-to-end/voice-calls).
     *
     * Parameters:
     * * `InputPhoneCall`    **peer**            - The phone call
     * * `bytes`             **g_a**             - [Parameter for E2E encryption key exchange »](https://core.telegram.org/api/end-to-end/voice-calls)
     * * `long`              **key_fingerprint** - Key fingerprint
     * * `PhoneCallProtocol` **protocol**        - Phone call settings
     *
     * @param array $params Parameters
     *
     * @return phone.PhoneCall
     */
    public function confirmCall($params);

    /**
     * Optional: notify the server that the user is currently busy in a call: this will automatically refuse all incoming phone calls until the current phone call is ended.
     *
     * Parameters:
     * * `InputPhoneCall` **peer** - The phone call we're currently in
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function receivedCall($params);

    /**
     * Refuse or end running call.
     *
     * Parameters:
     * * `boolean`                **video**         - Optional: Whether this is a video call
     * * `InputPhoneCall`         **peer**          - The phone call
     * * `int`                    **duration**      - Call duration
     * * `PhoneCallDiscardReason` **reason**        - Why was the call discarded
     * * `long`                   **connection_id** - Preferred libtgvoip relay ID
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function discardCall($params);

    /**
     * Rate a call.
     *
     * Parameters:
     * * `boolean`        **user_initiative** - Optional: Whether the user decided on their own initiative to rate the call
     * * `InputPhoneCall` **peer**            - The call to rate
     * * `int`            **rating**          - Rating in `1-5` stars
     * * `string`         **comment**         - An additional comment
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function setCallRating($params);

    /**
     * Send phone call debug data to server.
     *
     * Parameters:
     * * `InputPhoneCall` **peer**  - Phone call
     * * `DataJSON`       **debug** - Debug statistics obtained from libtgvoip
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function saveCallDebug($params);

    /**
     *
     *
     * Parameters:
     * * `InputPhoneCall` **peer** -
     * * `bytes`          **data** -.
     *
     * @param array $params Parameters
     *
     * @return bool
     */
    public function sendSignalingData($params);
}

interface langpack
{
    /**
     * Get localization pack strings.
     *
     * Parameters:
     * * `string` **lang_pack** - Language pack name
     * * `string` **lang_code** - Language code
     *
     * @param array $params Parameters
     *
     * @return LangPackDifference
     */
    public function getLangPack($params);

    /**
     * Get strings from a language pack.
     *
     * Parameters:
     * * `string`   **lang_pack** - Language pack name
     * * `string`   **lang_code** - Language code
     * * `[string]` **keys**      - Strings to get
     *
     * @param array $params Parameters
     *
     * @return  of LangPackString[]
     */
    public function getStrings($params);

    /**
     * Get new strings in languagepack.
     *
     * Parameters:
     * * `string` **lang_pack**    - Language pack
     * * `string` **lang_code**    - Language code
     * * `int`    **from_version** - Previous localization pack version
     *
     * @param array $params Parameters
     *
     * @return LangPackDifference
     */
    public function getDifference($params);

    /**
     * Get information about all languages in a localization pack.
     *
     * Parameters:
     * * `string` **lang_pack** - Language pack
     *
     * @param array $params Parameters
     *
     * @return  of LangPackLanguage[]
     */
    public function getLanguages($params);

    /**
     * Get information about a language in a localization pack.
     *
     * Parameters:
     * * `string` **lang_pack** - Language pack name
     * * `string` **lang_code** - Language code
     *
     * @param array $params Parameters
     *
     * @return LangPackLanguage
     */
    public function getLanguage($params);
}

interface folders
{
    /**
     * Edit peers in [peer folder](https://core.telegram.org/api/folders#peer-folders).
     *
     * Parameters:
     * * `[InputFolderPeer]` **folder_peers** - New peer list
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function editPeerFolders($params);

    /**
     * Delete a [peer folder](https://core.telegram.org/api/folders#peer-folders).
     *
     * Parameters:
     * * `int` **folder_id** - [Peer folder ID, for more info click here](https://core.telegram.org/api/folders#peer-folders)
     *
     * @param array $params Parameters
     *
     * @return Updates
     */
    public function deleteFolder($params);
}

interface stats
{
    /**
     * Get [channel statistics](https://core.telegram.org/api/stats).
     *
     * Parameters:
     * * `boolean`      **dark**    - Optional: Whether to enable dark theme for graph colors
     * * `InputChannel` **channel** - The channel
     *
     * @param array $params Parameters
     *
     * @return stats.BroadcastStats
     */
    public function getBroadcastStats($params);

    /**
     * Load [channel statistics graph](https://core.telegram.org/api/stats) asynchronously.
     *
     * Parameters:
     * * `string` **token** - Graph token from [statsGraphAsync](https://docs.madelineproto.xyz/API_docs/constructors/statsGraphAsync.html) constructor
     * * `long`   **x**     - Optional: Zoom value, if required
     *
     * @param array $params Parameters
     *
     * @return StatsGraph
     */
    public function loadAsyncGraph($params);

    /**
     *
     *
     * Parameters:
     * * `boolean`      **dark**    - Optional:
     * * `InputChannel` **channel** -.
     *
     * @param array $params Parameters
     *
     * @return stats.MegagroupStats
     */
    public function getMegagroupStats($params);

    /**
     *
     *
     * Parameters:
     * * `InputChannel` **channel**     -
     * * `int`          **msg_id**      -
     * * `int`          **offset_rate** -
     * * `InputPeer`    **offset_peer** -
     * * `int`          **offset_id**   -
     * * `int`          **limit**       -.
     *
     * @param array $params Parameters
     *
     * @return messages.Messages
     */
    public function getMessagePublicForwards($params);

    /**
     *
     *
     * Parameters:
     * * `boolean`      **dark**    - Optional:
     * * `InputChannel` **channel** -
     * * `int`          **msg_id**  -.
     *
     * @param array $params Parameters
     *
     * @return stats.MessageStats
     */
    public function getMessageStats($params);
}

class InternalDoc extends APIFactory
{
    /**
         * Convert MTProto parameters to bot API parameters.
         *
         * @param array $data Data
         *
         * @return \Amp\Promise<array>
         */
    public function MTProtoToBotAPI(array $data, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$data, $extra]);
    }
    /**
     * MTProto to TD params.
     *
     * @param mixed $params Params
     *
     * @return \Amp\Promise
     */
    public function MTProtoToTd(&$params, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$params, $extra]);
    }
    /**
     * MTProto to TDCLI params.
     *
     * @param mixed $params Params
     *
     * @return \Amp\Promise
     */
    public function MTProtoToTdcli($params, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$params, $extra]);
    }
    /**
     * Accept call.
     *
     * @param array $call Call
     *
     * @return \Amp\Promise
     */
    public function acceptCall(array $call, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$call, $extra]);
    }
    /**
     * Accept secret chat.
     *
     * @param array $params Secret chat ID
     *
     * @return \Amp\Promise
     */
    public function acceptSecretChat($params, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$params, $extra]);
    }
    /**
     * Accept terms of service update.
     *
     * @return \Amp\Promise
     */
    public function acceptTos(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Add user info.
     *
     * @param array $user User info
     *
     * @return \Amp\Promise
     * @throws \danog\MadelineProto\Exception
     */
    public function addUser(array $user, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$user, $extra]);
    }
    /**
     * Call promise $b after promise $a.
     *
     * @param \Generator|Promise $a Promise A
     * @param \Generator|Promise $b Promise B
     *
     * @psalm-suppress InvalidScope
     *
     * @return \Amp\Promise
     */
    public function after($a, $b)
    {
        return \danog\MadelineProto\Tools::after($a, $b);
    }
    /**
     * Returns a promise that succeeds when all promises succeed, and fails if any promise fails.
     * Returned promise succeeds with an array of values used to succeed each contained promise, with keys corresponding to the array of promises.
     *
     * @param array<\Generator|Promise> $promises Promises
     *
     * @return \Amp\Promise
     */
    public function all(array $promises)
    {
        return \danog\MadelineProto\Tools::all($promises);
    }
    /**
     * Returns a promise that is resolved when all promises are resolved. The returned promise will not fail.
     *
     * @param array<Promise|\Generator> $promises Promises
     *
     * @return \Amp\Promise
     */
    public function any(array $promises)
    {
        return \danog\MadelineProto\Tools::any($promises);
    }
    /**
     * Create array.
     *
     * @param mixed ...$params Params
     *
     * @return array
     */
    public function arr(...$params): array
    {
        return \danog\MadelineProto\Tools::arr(...$params);
    }
    /**
     * base64URL decode.
     *
     * @param string $data Data to decode
     *
     * @return string
     */
    public function base64urlDecode(string $data): string
    {
        return \danog\MadelineProto\Tools::base64urlDecode($data);
    }
    /**
     * Base64URL encode.
     *
     * @param string $data Data to encode
     *
     * @return string
     */
    public function base64urlEncode(string $data): string
    {
        return \danog\MadelineProto\Tools::base64urlEncode($data);
    }
    /**
     * Convert bot API parameters to MTProto parameters.
     *
     * @param array $arguments Arguments
     *
     * @return \Amp\Promise<array>
     */
    public function botAPIToMTProto(array $arguments, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$arguments, $extra]);
    }
    /**
     * Login as bot.
     *
     * @param string $token Bot token
     *
     * @return \Amp\Promise
     */
    public function botLogin(string $token, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$token, $extra]);
    }
    /**
     * Convert generator, promise or any other value to a promise.
     *
     * @param \Generator|Promise|mixed $promise
     *
     * @template TReturn
     * @psalm-param \Generator<mixed, mixed, mixed, TReturn>|Promise<TReturn>|TReturn $promise
     *
     * @return \Amp\Promise
     * @psalm-return Promise<TReturn>
     */
    public function call($promise)
    {
        return \danog\MadelineProto\Tools::call($promise);
    }
    /**
     * Call promise in background.
     *
     * @param \Generator|Promise  $promise Promise to resolve
     * @param ?\Generator|Promise $actual  Promise to resolve instead of $promise
     * @param string              $file    File
     *
     * @psalm-suppress InvalidScope
     *
     * @return \Amp\Promise|mixed
     */
    public function callFork($promise, $actual = null, $file = '')
    {
        return \danog\MadelineProto\Tools::callFork($promise, $actual, $file);
    }
    /**
     * Call promise in background, deferring execution.
     *
     * @param \Generator|Promise $promise Promise to resolve
     *
     * @return void
     */
    public function callForkDefer($promise): void
    {
        \danog\MadelineProto\Tools::callForkDefer($promise);
    }
    /**
     * Get call status.
     *
     * @param int $id Call ID
     *
     * @psalm-return int|\Amp\Promise<int>
     * @return mixed
     */
    public function callStatus($id)
    {
        return $this->__call(__FUNCTION__, [$id]);
    }
    /**
     * Check for terms of service update.
     *
     * @return \Amp\Promise
     */
    public function checkTos(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Cleanup memory and session file.
     *
     * @return \Amp\Promise
     */
    public function cleanup(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Close connection with client, connected via web.
     *
     * @param string $message Message
     *
     * @return void
     */
    public function closeConnection($message = 'OK!', array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$message, $extra]);
    }
    /**
     * Complete 2FA login.
     *
     * @param string $password Password
     *
     * @return \Amp\Promise
     */
    public function complete2faLogin(string $password, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$password, $extra]);
    }
    /**
     * Complete call handshake.
     *
     * @param array $params Params
     *
     * @return \Amp\Promise
     */
    public function completeCall(array $params, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$params, $extra]);
    }
    /**
     * Complet user login using login code.
     *
     * @param string $code Login code
     *
     * @return \Amp\Promise
     */
    public function completePhoneLogin($code, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$code, $extra]);
    }
    /**
     * Complete signup to Telegram.
     *
     * @param string $first_name First name
     * @param string $last_name  Last name
     *
     * @return \Amp\Promise
     */
    public function completeSignup(string $first_name, string $last_name = '', array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$first_name, $last_name, $extra]);
    }
    /**
     * Confirm call.
     *
     * @param array $params Params
     *
     * @return \Amp\Promise
     */
    public function confirmCall(array $params, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$params, $extra]);
    }
    /**
     * Connects to all datacenters and if necessary creates authorization keys, binds them and writes client info.
     *
     * @param boolean $reconnectAll Whether to reconnect to all DCs
     *
     * @return \Amp\Promise
     */
    public function connectToAllDcs(bool $reconnectAll = true, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$reconnectAll, $extra]);
    }
    /**
     * Decline terms of service update.
     *
     * THIS WILL DELETE YOUR ACCOUNT!
     *
     * @return \Amp\Promise
     */
    public function declineTos(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Discard call.
     *
     * @param array   $call       Call
     * @param array $reason
     * @param array   $rating     Rating
     * @param boolean $need_debug Need debug?
     *
     * @return \Amp\Promise
     */
    public function discardCall(array $call, array $reason, array $rating = [
    ], bool $need_debug = true, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$call, $reason, $rating, $need_debug, $extra]);
    }
    /**
     * Discard secret chat.
     *
     * @param int $chat Secret chat ID
     *
     * @return \Amp\Promise
     */
    public function discardSecretChat(int $chat, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$chat, $extra]);
    }
    /**
     * Download file to browser.
     *
     * Supports HEAD requests and content-ranges for parallel and resumed downloads.
     *
     * @param array|string $messageMedia File to download
     * @param callable     $cb           Status callback (can also use FileCallback)
     *
     * @return \Amp\Promise
     */
    public function downloadToBrowser($messageMedia, ?callable $cb = null, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$messageMedia, $cb, $extra]);
    }
    /**
     * Download file to callable.
     * The callable must accept two parameters: string $payload, int $offset
     * The callable will be called (possibly out of order, depending on the value of $seekable).
     * The callable should return the number of written bytes.
     *
     * @param mixed                          $messageMedia File to download
     * @param callable|FileCallbackInterface $callable      Chunk callback
     * @param callable                       $cb            Status callback (DEPRECATED, use FileCallbackInterface)
     * @param bool                           $seekable      Whether the callable can be called out of order
     * @param int                            $offset        Offset where to start downloading
     * @param int                            $end           Offset where to stop downloading (inclusive)
     * @param int                            $part_size     Size of each chunk
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<true>
     */
    public function downloadToCallable($messageMedia, callable $callable, $cb = null, bool $seekable = true, int $offset = 0, int $end = -1, ?int $part_size = null, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$messageMedia, $callable, $cb, $seekable, $offset, $end, $part_size, $extra]);
    }
    /**
     * Download file to directory.
     *
     * @param mixed                        $messageMedia File to download
     * @param string|FileCallbackInterface $dir           Directory where to download the file
     * @param callable                     $cb            Callback (DEPRECATED, use FileCallbackInterface)
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<false|string>
     */
    public function downloadToDir($messageMedia, $dir, $cb = null, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$messageMedia, $dir, $cb, $extra]);
    }
    /**
     * Download file.
     *
     * @param mixed                        $messageMedia File to download
     * @param string|FileCallbackInterface $file          Downloaded file path
     * @param callable                     $cb            Callback (DEPRECATED, use FileCallbackInterface)
     *
     * @return \Amp\Promise Downloaded file path
     *
     * @psalm-return \Amp\Promise<false|string>
     */
    public function downloadToFile($messageMedia, $file, $cb = null, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$messageMedia, $file, $cb, $extra]);
    }
    /**
     * Download file to amphp/http-server response.
     *
     * Supports HEAD requests and content-ranges for parallel and resumed downloads.
     *
     * @param array|string  $messageMedia File to download
     * @param ServerRequest $request      Request
     * @param callable      $cb           Status callback (can also use FileCallback)
     *
     * @return \Amp\Promise Returned response
     *
     * @psalm-return \Amp\Promise<\Amp\Http\Server\Response>
     */
    public function downloadToResponse($messageMedia, \Amp\Http\Server\Request $request, ?callable $cb = null, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$messageMedia, $request, $cb, $extra]);
    }
    /**
     * Download file to stream.
     *
     * @param mixed                       $messageMedia File to download
     * @param mixed|FileCallbackInterface $stream        Stream where to download file
     * @param callable                    $cb            Callback (DEPRECATED, use FileCallbackInterface)
     * @param int                         $offset        Offset where to start downloading
     * @param int                         $end           Offset where to end download
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<mixed>
     */
    public function downloadToStream($messageMedia, $stream, $cb = null, int $offset = 0, int $end = -1, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$messageMedia, $stream, $cb, $offset, $end, $extra]);
    }
    /**
     * Asynchronously write to stdout/browser.
     *
     * @param string $string Message to echo
     *
     * @return \Amp\Promise
     */
    public function echo(string $string)
    {
        return \danog\MadelineProto\Tools::echo($string);
    }
    /**
     * Get final element of array.
     *
     * @param array $what Array
     *
     * @return mixed
     */
    public function end(array $what)
    {
        return \danog\MadelineProto\Tools::end($what);
    }
    /**
     * Export authorization.
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<array{0: int|string, 1: string}>
     */
    public function exportAuthorization(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Extract file info from bot API message.
     *
     * @param array $info Bot API message object
     *
     * @return ?array
     */
    public function extractBotAPIFile(array $info): ?array
    {
        return \danog\MadelineProto\MTProto::extractBotAPIFile($info);
    }
    /**
     * Get contents of remote file asynchronously.
     *
     * @param string $url URL
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<string>
     */
    public function fileGetContents(string $url, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$url, $extra]);
    }
    /**
     * Returns a promise that succeeds when the first promise succeeds, and fails only if all promises fail.
     *
     * @param array<Promise|\Generator> $promises Promises
     *
     * @return \Amp\Promise
     */
    public function first(array $promises)
    {
        return \danog\MadelineProto\Tools::first($promises);
    }
    /**
     * Asynchronously lock a file
     * Resolves with a callbable that MUST eventually be called in order to release the lock.
     *
     * @param string    $file      File to lock
     * @param integer   $operation Locking mode
     * @param float     $polling   Polling interval
     * @param ?Promise  $token     Cancellation token
     * @param ?callable $failureCb Failure callback, called only once if the first locking attempt fails.
     *
     * @return \Amp\Promise<?callable>
     */
    public function flock(string $file, int $operation, float $polling = 0.1, ?\Amp\Promise $token = null, $failureCb = null)
    {
        return \danog\MadelineProto\Tools::flock($file, $operation, $polling, $token, $failureCb);
    }
    /**
     * Convert bot API channel ID to MTProto channel ID.
     *
     * @param int $id Bot API channel ID
     *
     * @return float|int
     */
    public function fromSupergroup($id)
    {
        return $this->__call(__FUNCTION__, [$id]);
    }
    /**
     * When were full info for this chat last cached.
     *
     * @param mixed $id Chat ID
     *
     * @return \Amp\Promise<integer>
     */
    public function fullChatLastUpdated($id, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$id, $extra]);
    }
    /**
     * Get info about the logged-in user, not cached.
     *
     * @return \Amp\Promise<array|bool>
     */
    public function fullGetSelf(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Generate MTProto vector hash.
     *
     * @param array $ints IDs
     *
     * @return int Vector hash
     */
    public function genVectorHash(array $ints): int
    {
        return \danog\MadelineProto\Tools::genVectorHash($ints);
    }
    /**
     * Get full list of MTProto and API methods.
     *
     * @psalm-return array|\Amp\Promise<array>
     * @return mixed
     */
    public function getAllMethods()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get authorization info.
     *
     * @psalm-return int|\Amp\Promise<int>
     * @return mixed
     */
    public function getAuthorization()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get cached server-side config.
     *
     * @psalm-return array|\Amp\Promise<array>
     * @return mixed
     */
    public function getCachedConfig()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get call info.
     *
     * @param int $call Call ID
     *
     * @psalm-return array|\Amp\Promise<array>
     * @return mixed
     */
    public function getCall($call)
    {
        return $this->__call(__FUNCTION__, [$call]);
    }
    /**
     * Store RSA keys for CDN datacenters.
     *
     * @param string $datacenter DC ID
     *
     * @return \Amp\Promise
     */
    public function getCdnConfig(string $datacenter, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$datacenter, $extra]);
    }
    /**
     * Get cached (or eventually re-fetch) server-side config.
     *
     * @param array $config  Current config
     * @param array $options Options for method call
     *
     * @return \Amp\Promise
     */
    public function getConfig(array $config = [
    ], array $options = [
    ], array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$config, $options, $extra]);
    }
    /**
     * Get async DNS client.
     *
     * @psalm-return \Amp\Dns\Resolver|\Amp\Promise<\Amp\Dns\Resolver>
     * @return mixed
     */
    public function getDNSClient()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get all datacenter connections.
     *
     * @psalm-return array<DataCenterConnection>|\Amp\Promise<array<DataCenterConnection>>
     * @return mixed
     */
    public function getDataCenterConnections()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get main DC ID.
     *
     * @return int|string
     */
    public function getDataCenterId(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Get dialog peers.
     *
     * @param boolean $force Whether to refetch all dialogs ignoring cache
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<list<mixed>>
     */
    public function getDialogs(bool $force = true, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$force, $extra]);
    }
    /**
     * Get download info of file
     * Returns an array with the following structure:.
     *
     * `$info['ext']` - The file extension
     * `$info['name']` - The file name, without the extension
     * `$info['mime']` - The file mime type
     * `$info['size']` - The file size
     *
     * @param mixed $messageMedia File ID
     *
     * @return \Amp\Promise<array>
     */
    public function getDownloadInfo($messageMedia, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$messageMedia, $extra]);
    }
    /**
     * Get event handler.
     *
     * @psalm-return \danog\MadelineProto\EventHandler|\Amp\Promise<\danog\MadelineProto\EventHandler>
     * @return mixed
     */
    public function getEventHandler()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get extension from file location.
     *
     * @param mixed  $location File location
     * @param string $default  Default extension
     *
     * @return string
     */
    public function getExtensionFromLocation($location, string $default): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getExtensionFromLocation($location, $default);
    }
    /**
     * Get extension from mime type.
     *
     * @param string $mime MIME type
     *
     * @return string
     */
    public function getExtensionFromMime(string $mime): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getExtensionFromMime($mime);
    }
    /**
     * Get info about file.
     *
     * @param mixed $constructor File ID
     *
     * @return \Amp\Promise<array>
     */
    public function getFileInfo($constructor, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$constructor, $extra]);
    }
    /**
     * Get folder ID from object.
     *
     * @param mixed $id Object
     *
     * @return ?int
     */
    public function getFolderId($id): ?int
    {
        return \danog\MadelineProto\MTProto::getFolderId($id);
    }
    /**
     * Get full info of all dialogs.
     *
     * @param boolean $force Whether to refetch all dialogs ignoring cache
     *
     * @return \Amp\Promise
     */
    public function getFullDialogs(bool $force = true, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$force, $extra]);
    }
    /**
     * Get full info about peer, returns an FullInfo object.
     *
     * @param mixed $id Peer
     *
     * @see https://docs.madelineproto.xyz/FullInfo.html
     *
     * @return \Amp\Promise FullInfo object
     *
     * @psalm-return \Amp\Promise<array>
     */
    public function getFullInfo($id, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$id, $extra]);
    }
    /**
     * Get async HTTP client.
     *
     * @psalm-return \Amp\Http\Client\HttpClient|\Amp\Promise<\Amp\Http\Client\HttpClient>
     * @return mixed
     */
    public function getHTTPClient()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get current password hint.
     *
     * @psalm-return string|\Amp\Promise<string>
     * @return mixed
     */
    public function getHint()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get bot API ID from peer object.
     *
     * @param mixed $id Peer
     *
     * @return int
     */
    public function getId($id, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$id, $extra]);
    }
    /**
     * Get info about peer, returns an Info object.
     *
     * @param mixed                $id        Peer
     * @param MTProto::INFO_TYPE_* $type      Whether to generate an Input*, an InputPeer or the full set of constructors
     * @param boolean              $recursive Internal
     *
     * @see https://docs.madelineproto.xyz/Info.html
     *
     * @return \Amp\Promise Info object
     *
     * @template TConstructor
     * @psalm-param $id array{_: TConstructor}|mixed
     *
     * @return (((mixed|string)[]|mixed|string)[]|int|mixed|string)[]
     *
     * @psalm-return \Generator<int|mixed, \Amp\Promise|\Amp\Promise<string>|array, mixed, array{
     *      TConstructor: array
     *      InputPeer: array{_: string, user_id?: mixed, access_hash?: mixed, min?: mixed, chat_id?: mixed, channel_id?: mixed},
     *      Peer: array{_: string, user_id?: mixed, chat_id?: mixed, channel_id?: mixed},
     *      DialogPeer: array{_: string, peer: array{_: string, user_id?: mixed, chat_id?: mixed, channel_id?: mixed}},
     *      NotifyPeer: array{_: string, peer: array{_: string, user_id?: mixed, chat_id?: mixed, channel_id?: mixed}},
     *      InputDialogPeer: array{_: string, peer: array{_: string, user_id?: mixed, access_hash?: mixed, min?: mixed, chat_id?: mixed, channel_id?: mixed}},
     *      InputNotifyPeer: array{_: string, peer: array{_: string, user_id?: mixed, access_hash?: mixed, min?: mixed, chat_id?: mixed, channel_id?: mixed}},
     *      bot_api_id: int|string,
     *      user_id?: int,
     *      chat_id?: int,
     *      channel_id?: int,
     *      InputUser?: array{_: string, user_id?: int, access_hash?: mixed, min?: bool},
     *      InputChannel?: array{_: string, channel_id: int, access_hash: mixed, min: bool},
     *      type: string
     * }>|int|array{_: string, user_id?: mixed, access_hash?: mixed, min?: mixed, chat_id?: mixed, channel_id?: mixed}|array{_: string, user_id?: int, access_hash?: mixed, min?: bool}|array{_: string, channel_id: int, access_hash: mixed, min: bool}
     */
    public function getInfo($id, int $type = \danog\MadelineProto\MTProto::INFO_TYPE_ALL, $recursive = true, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$id, $type, $recursive, $extra]);
    }
    /**
     * Get logger.
     */
    public function getLogger()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get TL namespaces.
     *
     * @psalm-return array|\Amp\Promise<array>
     * @return mixed
     */
    public function getMethodNamespaces()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get namespaced methods (method => namespace).
     *
     * @psalm-return array|\Amp\Promise<array>
     * @return mixed
     */
    public function getMethodsNamespaced()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get mime type from buffer.
     *
     * @param string $buffer Buffer
     *
     * @return string
     */
    public function getMimeFromBuffer(string $buffer): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getMimeFromBuffer($buffer);
    }
    /**
     * Get mime type from file extension.
     *
     * @param string $extension File extension
     * @param string $default   Default mime type
     *
     * @return string
     */
    public function getMimeFromExtension(string $extension, string $default): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getMimeFromExtension($extension, $default);
    }
    /**
     * Get mime type of file.
     *
     * @param string $file File
     *
     * @return string
     */
    public function getMimeFromFile(string $file): string
    {
        return \danog\MadelineProto\TL\Conversion\Extension::getMimeFromFile($file);
    }
    /**
     * Get download info of the propic of a user
     * Returns an array with the following structure:.
     *
     * `$info['ext']` - The file extension
     * `$info['name']` - The file name, without the extension
     * `$info['mime']` - The file mime type
     * `$info['size']` - The file size
     *
     * @param mixed $messageMedia File ID
     *
     * @return \Amp\Promise<array>
     */
    public function getPropicInfo($data, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$data, $extra]);
    }
    /**
     * Get PSR logger.
     */
    public function getPsrLogger()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get full info about peer (including full list of channel members), returns a Chat object.
     *
     * @param mixed $id Peer
     *
     * @see https://docs.madelineproto.xyz/Chat.html
     *
     * @return \Amp\Promise Chat object
     */
    public function getPwrChat($id, bool $fullfetch = true, bool $send = true, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$id, $fullfetch, $send, $extra]);
    }
    /**
     * Get secret chat.
     *
     * @param array|int $chat Secret chat ID
     *
     * @psalm-return array|\Amp\Promise<array>
     * @return mixed
     */
    public function getSecretChat($chat)
    {
        return $this->__call(__FUNCTION__, [$chat]);
    }
    /**
     * Get info about the logged-in user, cached.
     *
     * @return array|bool
     */
    public function getSelf(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Return current settings.
     *
     * @psalm-return \danog\MadelineProto\Settings|\Amp\Promise<\danog\MadelineProto\Settings>
     * @return mixed
     */
    public function getSettings()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Get TL serializer.
     *
     * @psalm-return \danog\MadelineProto\TL\TL|\Amp\Promise<\danog\MadelineProto\TL\TL>
     * @return mixed
     */
    public function getTL()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Accesses a private variable from an object.
     *
     * @param object $obj Object
     * @param string $var Attribute name
     *
     * @psalm-suppress InvalidScope
     *
     * @return mixed
     * @access public
     */
    public function getVar($obj, string $var)
    {
        return \danog\MadelineProto\Tools::getVar($obj, $var);
    }
    /**
     * Get web template.
     *
     * @psalm-return string|\Amp\Promise<string>
     * @return mixed
     */
    public function getWebTemplate()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Checks whether all datacenters are authorized.
     *
     * @psalm-return bool|\Amp\Promise<bool>
     * @return mixed
     */
    public function hasAllAuth()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Check if an event handler instance is present.
     *
     * @psalm-return bool|\Amp\Promise<bool>
     * @return mixed
     */
    public function hasEventHandler()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Check if has report peers.
     *
     * @psalm-return bool|\Amp\Promise<bool>
     * @return mixed
     */
    public function hasReportPeers()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Check whether secret chat exists.
     *
     * @param array|int $chat Secret chat ID
     *
     * @psalm-return bool|\Amp\Promise<bool>
     * @return mixed
     */
    public function hasSecretChat($chat)
    {
        return $this->__call(__FUNCTION__, [$chat]);
    }
    /**
     * Checks private property exists in an object.
     *
     * @param object $obj Object
     * @param string $var Attribute name
     *
     * @psalm-suppress InvalidScope
     *
     * @return bool
     * @access public
     */
    public function hasVar($obj, string $var): bool
    {
        return \danog\MadelineProto\Tools::hasVar($obj, $var);
    }
    /**
     * Import authorization.
     *
     * @param mixed $authorization Authorization info
     *
     * @return \Amp\Promise
     */
    public function importAuthorization($authorization, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$authorization, $extra]);
    }
    /**
     * Inflate stripped photosize to full JPG payload.
     *
     * @param string $stripped Stripped photosize
     *
     * @return string JPG payload
     */
    public function inflateStripped(string $stripped): string
    {
        return \danog\MadelineProto\Tools::inflateStripped($stripped);
    }
    /**
     * Initialize self-restart hack.
     *
     * @psalm-return void|\Amp\Promise<void>
     * @return mixed
     */
    public function initSelfRestart()
    {
        $this->__call(__FUNCTION__, []);
    }
    /**
     * Whether this is altervista.
     *
     * @return boolean
     */
    public function isAltervista(): bool
    {
        return \danog\MadelineProto\Tools::isAltervista();
    }
    /**
     * Check if is array or similar (traversable && countable && arrayAccess).
     *
     * @param mixed $var Value to check
     *
     * @return boolean
     */
    public function isArrayOrAlike($var): bool
    {
        return \danog\MadelineProto\Tools::isArrayOrAlike($var);
    }
    /**
     * Whether we're an IPC client instance.
     *
     * @psalm-return bool|\Amp\Promise<bool>
     * @return mixed
     */
    public function isIpc()
    {
        return $this->__call(__FUNCTION__, []);
    }
    /**
     * Check whether provided bot API ID is a channel.
     *
     * @param int $id Bot API ID
     *
     * @return boolean
     */
    public function isSupergroup($id): bool
    {
        return \danog\MadelineProto\MTProto::isSupergroup($id);
    }
    /**
     * Logger.
     *
     * @param string $param Parameter
     * @param int    $level Logging level
     * @param string $file  File where the message originated
     *
     * @psalm-return void|\Amp\Promise<void>
     * @return mixed
     */
    public function logger($param, int $level = \danog\MadelineProto\Logger::NOTICE, string $file = '')
    {
        $this->__call(__FUNCTION__, [$param, $level, $file]);
    }
    /**
     * Log out currently logged in user.
     *
     * @return \Amp\Promise
     */
    public function logout(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Start MadelineProto's update handling loop, or run the provided async callable.
     *
     * @param callable|null $callback Async callable to run
     *
     * @return \Amp\Promise
     */
    public function loop($callback = null, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$callback, $extra]);
    }
    /**
     * Start MadelineProto's update handling loop in background.
     *
     * @return \Amp\Promise
     */
    public function loopFork(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Escape string for markdown.
     *
     * @param string $hwat String to escape
     *
     * @return string
     */
    public function markdownEscape(string $hwat): string
    {
        return \danog\MadelineProto\StrTools::markdownEscape($hwat);
    }
    /**
     * Telegram UTF-8 multibyte split.
     *
     * @param string  $text   Text
     * @param integer $length Length
     *
     * @return array
     */
    public function mbStrSplit(string $text, int $length): array
    {
        return \danog\MadelineProto\MTProto::mbStrSplit($text, $length);
    }
    /**
     * Get Telegram UTF-8 length of string.
     *
     * @param string $text Text
     *
     * @return float|int
     */
    public function mbStrlen(string $text)
    {
        return $this->__call(__FUNCTION__, [$text]);
    }
    /**
     * Telegram UTF-8 multibyte substring.
     *
     * @param string  $text   Text to substring
     * @param integer $offset Offset
     * @param ?int    $length Length
     *
     * @return string
     */
    public function mbSubstr(string $text, int $offset, $length = null): string
    {
        return \danog\MadelineProto\MTProto::mbSubstr($text, $offset, $length);
    }
    /**
     * Call method and wait asynchronously for response.
     *
     * If the $aargs['noResponse'] is true, will not wait for a response.
     *
     * @param string            $method Method name
     * @param array|\Generator  $args   Arguments
     * @param array             $aargs  Additional arguments
     *
     * @psalm-param array|\Generator<mixed, mixed, mixed, array> $args
     *
     * @return \Amp\Promise
     */
    public function methodCall(string $method, $args = [
    ], array $aargs = [
      'msg_id' => null,
    ], array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$method, $args, $aargs, $extra]);
    }
    /**
     * Call method and make sure it is asynchronously sent.
     *
     * @param string            $method Method name
     * @param array|\Generator  $args   Arguments
     * @param array             $aargs  Additional arguments
     *
     * @psalm-param array|\Generator<mixed, mixed, mixed, array> $args
     *
     * @return \Amp\Promise
     */
    public function methodCallWrite(string $method, $args = [
    ], array $aargs = [
      'msg_id' => null,
    ], array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$method, $args, $aargs, $extra]);
    }
    /**
     * Escape method name.
     *
     * @param string $method Method name
     *
     * @return string
     */
    public function methodEscape(string $method): string
    {
        return \danog\MadelineProto\StrTools::methodEscape($method);
    }
    /**
     * Convert double to binary version.
     *
     * @param float $value Value to convert
     *
     * @return string
     */
    public function packDouble(float $value): string
    {
        return \danog\MadelineProto\Tools::packDouble($value);
    }
    /**
     * Convert integer to base256 signed int.
     *
     * @param integer $value Value to convert
     *
     * @return string
     */
    public function packSignedInt(int $value): string
    {
        return \danog\MadelineProto\Tools::packSignedInt($value);
    }
    /**
     * Convert integer to base256 long.
     *
     * @param int $value Value to convert
     *
     * @return string
     */
    public function packSignedLong(int $value): string
    {
        return \danog\MadelineProto\Tools::packSignedLong($value);
    }
    /**
     * Convert value to unsigned base256 int.
     *
     * @param int $value Value
     *
     * @return string
     */
    public function packUnsignedInt(int $value): string
    {
        return \danog\MadelineProto\Tools::packUnsignedInt($value);
    }
    /**
     * Check if peer is present in internal peer database.
     *
     * @param mixed $id Peer
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<bool>
     */
    public function peerIsset($id, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$id, $extra]);
    }
    /**
     * Login as user.
     *
     * @param string  $number   Phone number
     * @param integer $sms_type SMS type
     *
     * @return \Amp\Promise
     */
    public function phoneLogin($number, $sms_type = 5, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$number, $sms_type, $extra]);
    }
    /**
     * Positive modulo
     * Works just like the % (modulus) operator, only returns always a postive number.
     *
     * @param int $a A
     * @param int $b B
     *
     * @return int Modulo
     */
    public function posmod(int $a, int $b): int
    {
        return \danog\MadelineProto\Tools::posmod($a, $b);
    }
    /**
     * Get random string of specified length.
     *
     * @param integer $length Length
     *
     * @return string Random string
     */
    public function random(int $length): string
    {
        return \danog\MadelineProto\Tools::random($length);
    }
    /**
     * Get random integer.
     *
     * @param integer $modulus Modulus
     *
     * @return int
     */
    public function randomInt(int $modulus = 0): int
    {
        return \danog\MadelineProto\Tools::randomInt($modulus);
    }
    /**
     * Asynchronously read line.
     *
     * @param string $prompt Prompt
     *
     * @return \Amp\Promise<string>
     */
    public function readLine(string $prompt = '')
    {
        return \danog\MadelineProto\Tools::readLine($prompt);
    }
    /**
     * Rekey secret chat.
     *
     * @param int $chat Secret chat to rekey
     *
     * @return \Amp\Promise
     */
    public function rekey(int $chat, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$chat, $extra]);
    }
    /**
     * Report an error to the previously set peer.
     *
     * @param string $message   Error to report
     * @param string $parseMode Parse mode
     *
     * @return \Amp\Promise
     */
    public function report(string $message, string $parseMode = '', array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$message, $parseMode, $extra]);
    }
    /**
     * Request VoIP call.
     *
     * @param mixed $user User
     *
     * @return \Amp\Promise
     */
    public function requestCall($user, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$user, $extra]);
    }
    /**
     * Request secret chat.
     *
     * @param mixed $user User to start secret chat with
     *
     * @return \Amp\Promise
     */
    public function requestSecretChat($user, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$user, $extra]);
    }
    /**
     * Reset the update state and fetch all updates from the beginning.
     *
     * @psalm-return void|\Amp\Promise<void>
     * @return mixed
     */
    public function resetUpdateState()
    {
        $this->__call(__FUNCTION__, []);
    }
    /**
     * Resolve username (use getInfo instead).
     *
     * @param string $username Username
     *
     * @return \Amp\Promise
     */
    public function resolveUsername(string $username, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$username, $extra]);
    }
    /**
     * Restart update loop.
     *
     * @return void
     */
    public function restart(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Rethrow error catched in strand.
     *
     * @param \Throwable $e    Exception
     * @param string     $file File where the strand started
     *
     * @psalm-suppress InvalidScope
     *
     * @return void
     */
    public function rethrow(\Throwable $e, $file = ''): void
    {
        \danog\MadelineProto\Tools::rethrow($e, $file);
    }
    /**
     * null-byte RLE decode.
     *
     * @param string $string Data to decode
     *
     * @return string
     */
    public function rleDecode(string $string): string
    {
        return \danog\MadelineProto\Tools::rleDecode($string);
    }
    /**
     * null-byte RLE encode.
     *
     * @param string $string Data to encode
     *
     * @return string
     */
    public function rleEncode(string $string): string
    {
        return \danog\MadelineProto\Tools::rleEncode($string);
    }
    /**
     * Get secret chat status.
     *
     * @param int $chat Chat ID
     *
     * @psalm-return int|\Amp\Promise<int>
     * @return mixed
     */
    public function secretChatStatus(int $chat)
    {
        return $this->__call(__FUNCTION__, [$chat]);
    }
    /**
     * Serialize all instances.
     *
     * CALLED ONLY ON SHUTDOWN.
     *
     * @return void
     */
    public function serializeAll(): void
    {
        \danog\MadelineProto\MTProto::serializeAll();
    }
    /**
     * Set update handling callback.
     *
     * @param callable $callback Callback
     *
     * @psalm-return void|\Amp\Promise<void>
     * @return mixed
     */
    public function setCallback($callback)
    {
        $this->__call(__FUNCTION__, [$callback]);
    }
    /**
     * Set event handler.
     *
     * @param class-string<EventHandler> $eventHandler Event handler
     *
     * @return \Amp\Promise
     */
    public function setEventHandler(string $eventHandler, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$eventHandler, $extra]);
    }
    /**
     * Set NOOP update handler, ignoring all updates.
     *
     * @psalm-return void|\Amp\Promise<void>
     * @return mixed
     */
    public function setNoop()
    {
        $this->__call(__FUNCTION__, []);
    }
    /**
     * Set peer(s) where to send errors occurred in the event loop.
     *
     * @param int|string $userOrId Username(s) or peer ID(s)
     *
     * @return \Amp\Promise
     */
    public function setReportPeers($userOrId, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$userOrId, $extra]);
    }
    /**
     * Sets a private variable in an object.
     *
     * @param object $obj Object
     * @param string $var Attribute name
     * @param mixed  $val Attribute value
     *
     * @psalm-suppress InvalidScope
     *
     * @return void
     *
     * @access public
     */
    public function setVar($obj, string $var, &$val): void
    {
        \danog\MadelineProto\Tools::setVar($obj, $var, $val);
    }
    /**
     * Set web template.
     *
     * @param string $template Template
     *
     * @psalm-return void|\Amp\Promise<void>
     * @return mixed
     */
    public function setWebTemplate(string $template)
    {
        $this->__call(__FUNCTION__, [$template]);
    }
    /**
     * Set webhook update handler.
     *
     * @param string $hook_url Webhook URL
     * @param string $pem_path PEM path for self-signed certificate
     *
     * @psalm-return void|\Amp\Promise<void>
     * @return mixed
     */
    public function setWebhook(string $hook_url, string $pem_path = '')
    {
        $this->__call(__FUNCTION__, [$hook_url, $pem_path]);
    }
    /**
     * Setup logger.
     *
     * @psalm-return void|\Amp\Promise<void>
     * @return mixed
     */
    public function setupLogger()
    {
        $this->__call(__FUNCTION__, []);
    }
    /**
     * Asynchronously sleep.
     *
     * @param int|float $time Number of seconds to sleep for
     *
     * @return \Amp\Promise
     */
    public function sleep($time)
    {
        return \danog\MadelineProto\Tools::sleep($time);
    }
    /**
     * Resolves with a two-item array delineating successful and failed Promise results.
     * The returned promise will only fail if the given number of required promises fail.
     *
     * @param array<Promise|\Generator> $promises Promises
     *
     * @return \Amp\Promise
     */
    public function some(array $promises)
    {
        return \danog\MadelineProto\Tools::some($promises);
    }
    /**
     * Log in to telegram (via CLI or web).
     *
     * @return \Amp\Promise
     */
    public function start(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Stop update loop.
     *
     * @return void
     */
    public function stop(array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$extra]);
    }
    /**
     * Convert TD to MTProto parameters.
     *
     * @param array $params Parameters
     *
     * @return \Amp\Promise<array>
     */
    public function tdToMTProto(array $params, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$params, $extra]);
    }
    /**
     * Convert TD parameters to tdcli.
     *
     * @param mixed $params Parameters
     *
     * @return mixed
     */
    public function tdToTdcli($params, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$params, $extra]);
    }
    /**
     * Convert tdcli parameters to tdcli.
     *
     * @param array $params Params
     * @param array $key    Key
     *
     * @psalm-return array|\Amp\Promise<array>
     * @return mixed
     */
    public function tdcliToTd(&$params, $key = null)
    {
        return $this->__call(__FUNCTION__, [$params, $key]);
    }
    /**
     * Create an artificial timeout for any \Generator or Promise.
     *
     * @param \Generator|Promise $promise
     * @param integer $timeout
     *
     * @return \Amp\Promise
     */
    public function timeout($promise, int $timeout)
    {
        return \danog\MadelineProto\Tools::timeout($promise, $timeout);
    }
    /**
     * Creates an artificial timeout for any `Promise`.
     *
     * If the promise is resolved before the timeout expires, the result is returned
     *
     * If the timeout expires before the promise is resolved, a default value is returned
     *
     * @template TReturnAlt
     * @template TReturn
     * @template TGenerator as \Generator<mixed, mixed, mixed, TReturn>
     *
     * @param Promise|Generator $promise Promise to which the timeout is applied.
     * @param int               $timeout Timeout in milliseconds.
     * @param mixed             $default
     *
     * @psalm-param Promise<TReturn>|TGenerator $promise Promise to which the timeout is applied.
     * @psalm-param TReturnAlt $default
     *
     * @return \Amp\Promise<TReturn>|Promise<TReturnAlt>
     *
     * @throws \TypeError If $promise is not an instance of \Amp\Promise, \Generator or \React\Promise\PromiseInterface.
     */
    public function timeoutWithDefault($promise, int $timeout, $default = null)
    {
        return \danog\MadelineProto\Tools::timeoutWithDefault($promise, $timeout, $default);
    }
    /**
     * Convert to camelCase.
     *
     * @param string $input String
     *
     * @return string
     */
    public function toCamelCase(string $input): string
    {
        return \danog\MadelineProto\StrTools::toCamelCase($input);
    }
    /**
     * Convert to snake_case.
     *
     * @param string $input String
     *
     * @return string
     */
    public function toSnakeCase(string $input): string
    {
        return \danog\MadelineProto\StrTools::toSnakeCase($input);
    }
    /**
     * Convert MTProto channel ID to bot API channel ID.
     *
     * @param int $id MTProto channel ID
     *
     * @return float|int
     */
    public function toSupergroup($id)
    {
        return $this->__call(__FUNCTION__, [$id]);
    }
    /**
     * Escape type name.
     *
     * @param string $type String to escape
     *
     * @return string
     */
    public function typeEscape(string $type): string
    {
        return \danog\MadelineProto\StrTools::typeEscape($type);
    }
    /**
     * Unpack binary double.
     *
     * @param string $value Value to unpack
     *
     * @return float
     */
    public function unpackDouble(string $value): float
    {
        return \danog\MadelineProto\Tools::unpackDouble($value);
    }
    /**
     * Unpack bot API file ID.
     *
     * @param string $fileId Bot API file ID
     *
     * @psalm-return array|\Amp\Promise<array>
     * @return mixed
     */
    public function unpackFileId(string $fileId)
    {
        return $this->__call(__FUNCTION__, [$fileId]);
    }
    /**
     * Unpack base256 signed int.
     *
     * @param string $value base256 int
     *
     * @return integer
     */
    public function unpackSignedInt(string $value): int
    {
        return \danog\MadelineProto\Tools::unpackSignedInt($value);
    }
    /**
     * Unpack base256 signed long.
     *
     * @param string $value base256 long
     *
     * @return integer
     */
    public function unpackSignedLong(string $value): int
    {
        return \danog\MadelineProto\Tools::unpackSignedLong($value);
    }
    /**
     * Unpack base256 signed long to string.
     *
     * @param string $value base256 long
     *
     * @return string
     */
    public function unpackSignedLongString($value): string
    {
        return \danog\MadelineProto\Tools::unpackSignedLongString($value);
    }
    /**
     * Unset event handler.
     *
     * @param bool $disableUpdateHandling Whether to also disable internal update handling (will cause errors, otherwise will simply use the NOOP handler)
     *
     * @psalm-return void|\Amp\Promise<void>
     * @return mixed
     */
    public function unsetEventHandler(bool $disableUpdateHandling = false)
    {
        $this->__call(__FUNCTION__, [$disableUpdateHandling]);
    }
    /**
     * Update the 2FA password.
     *
     * The params array can contain password, new_password, email and hint params.
     *
     * @param array $params The params
     *
     * @return \Amp\Promise
     */
    public function update2fa(array $params, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$params, $extra]);
    }
    /**
     * Parse, update and store settings.
     *
     * @param SettingsAbstract $settings Settings
     *
     * @return \Amp\Promise
     */
    public function updateSettings(\danog\MadelineProto\SettingsAbstract $settings, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$settings, $extra]);
    }
    /**
     * Upload file.
     *
     * @param FileCallbackInterface|string|array $file      File, URL or Telegram file to upload
     * @param string                             $fileName  File name
     * @param callable                           $cb        Callback (DEPRECATED, use FileCallbackInterface)
     * @param boolean                            $encrypted Whether to encrypt file for secret chats
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<mixed>
     */
    public function upload($file, string $fileName = '', $cb = null, bool $encrypted = false, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$file, $fileName, $cb, $encrypted, $extra]);
    }
    /**
     * Upload file to secret chat.
     *
     * @param FileCallbackInterface|string|array $file      File, URL or Telegram file to upload
     * @param string                             $fileName  File name
     * @param callable                           $cb        Callback (DEPRECATED, use FileCallbackInterface)
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<mixed>
     */
    public function uploadEncrypted($file, string $fileName = '', $cb = null, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$file, $fileName, $cb, $extra]);
    }
    /**
     * Upload file from callable.
     *
     * The callable must accept two parameters: int $offset, int $size
     * The callable must return a string with the contest of the file at the specified offset and size.
     *
     * @param mixed    $callable  Callable
     * @param integer  $size      File size
     * @param string   $mime      Mime type
     * @param string   $fileName  File name
     * @param callable $cb        Callback (DEPRECATED, use FileCallbackInterface)
     * @param boolean  $seekable  Whether chunks can be fetched out of order
     * @param boolean  $encrypted Whether to encrypt file for secret chats
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<array{_: string, id: string, parts: int, name: string, mime_type: string, key_fingerprint?: mixed, key?: mixed, iv?: mixed, md5_checksum: string}>
     */
    public function uploadFromCallable(callable $callable, int $size, string $mime, string $fileName = '', $cb = null, bool $seekable = true, bool $encrypted = false, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$callable, $size, $mime, $fileName, $cb, $seekable, $encrypted, $extra]);
    }
    /**
     * Upload file from stream.
     *
     * @param mixed    $stream    PHP resource or AMPHP async stream
     * @param integer  $size      File size
     * @param string   $mime      Mime type
     * @param string   $fileName  File name
     * @param callable $cb        Callback (DEPRECATED, use FileCallbackInterface)
     * @param boolean  $encrypted Whether to encrypt file for secret chats
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<mixed>
     */
    public function uploadFromStream($stream, int $size, string $mime, string $fileName = '', $cb = null, bool $encrypted = false, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$stream, $size, $mime, $fileName, $cb, $encrypted, $extra]);
    }
    /**
     * Reupload telegram file.
     *
     * @param mixed    $media     Telegram file
     * @param callable $cb        Callback (DEPRECATED, use FileCallbackInterface)
     * @param boolean  $encrypted Whether to encrypt file for secret chats
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<mixed>
     */
    public function uploadFromTgfile($media, $cb = null, bool $encrypted = false, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$media, $cb, $encrypted, $extra]);
    }
    /**
     * Upload file from URL.
     *
     * @param string|FileCallbackInterface $url       URL of file
     * @param integer                      $size      Size of file
     * @param string                       $fileName  File name
     * @param callable                     $cb        Callback (DEPRECATED, use FileCallbackInterface)
     * @param boolean                      $encrypted Whether to encrypt file for secret chats
     *
     * @return \Amp\Promise
     *
     * @psalm-return \Amp\Promise<mixed>
     */
    public function uploadFromUrl($url, int $size = 0, string $fileName = '', $cb = null, bool $encrypted = false, array $extra = [])
    {
        return $this->__call(__FUNCTION__, [$url, $size, $fileName, $cb, $encrypted, $extra]);
    }
    /**
     * Synchronously wait for a promise|generator.
     *
     * @param \Generator|Promise $promise      The promise to wait for
     * @param boolean            $ignoreSignal Whether to ignore shutdown signals
     *
     * @return mixed
     */
    public function wait($promise, $ignoreSignal = false)
    {
        return \danog\MadelineProto\Tools::wait($promise, $ignoreSignal);
    }
}
